/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item.armor;

import com.iafenvoy.iceandfire.data.SeaSerpentType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SeaSerpentArmorItem
extends ArmorItem {
    public final SeaSerpentType armorType;

    public SeaSerpentArmorItem(SeaSerpentType armorType, Holder<ArmorMaterial> material, ArmorItem.Type slot) {
        Item.Properties properties = new Item.Properties();
        super(material, slot, properties.durability(switch (slot) {
            default -> throw new MatchException(null, null);
            case ArmorItem.Type.HELMET -> 330;
            case ArmorItem.Type.CHESTPLATE -> 480;
            case ArmorItem.Type.LEGGINGS -> 450;
            case ArmorItem.Type.BOOTS -> 390;
            case ArmorItem.Type.BODY -> 0;
        }));
        this.armorType = armorType;
    }

    public String getDescriptionId() {
        return "item.%s.sea_serpent_%s".formatted("iceandfire", this.type.getName());
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        int footMod;
        int legMod;
        int chestMod;
        int headMod;
        int modifier;
        Player player;
        super.inventoryTick(stack, world, entity, slot, selected);
        if (entity instanceof Player && (player = (Player)entity).getItemBySlot(this.getEquipmentSlot()) == stack && (modifier = (headMod = player.getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof SeaSerpentArmorItem ? 1 : 0) + (chestMod = player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof SeaSerpentArmorItem ? 1 : 0) + (legMod = player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof SeaSerpentArmorItem ? 1 : 0) + (footMod = player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof SeaSerpentArmorItem ? 1 : 0) - 1) >= 0) {
            player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 50, 0, false, false));
            if (player.isInWaterOrRain()) {
                player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_BOOST, 50, modifier, false, false));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)("sea_serpent." + this.armorType.getName())).withStyle(this.armorType.getColor()));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.sea_serpent_armor.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.sea_serpent_armor.desc_1").withStyle(ChatFormatting.GRAY));
    }
}

