/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.registry.IafDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CyclopsEyeItem
extends Item {
    public CyclopsEyeItem() {
        super(new Item.Properties().durability(500).component((DataComponentType)IafDataComponents.INT.get(), (Object)0));
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int tick = (Integer)stack.get((DataComponentType)IafDataComponents.INT.get());
            if (living.getMainHandItem() == stack || living.getOffhandItem() == stack) {
                double range = 15.0;
                boolean inflictedDamage = false;
                for (Mob LivingEntity2 : world.getEntitiesOfClass(Mob.class, new AABB(living.getX() - range, living.getY() - range, living.getZ() - range, living.getX() + range, living.getY() + range, living.getZ() + range))) {
                    if (LivingEntity2.is((Entity)living) || LivingEntity2.isAlliedTo((Entity)living) || LivingEntity2.getTarget() != living && LivingEntity2.getLastHurtByMob() != living && !(LivingEntity2 instanceof Enemy)) continue;
                    LivingEntity2.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 10, 1));
                    inflictedDamage = true;
                }
                if (inflictedDamage) {
                    ++tick;
                }
            }
            if (tick > 120) {
                stack.hurtAndBreak(1, living, LivingEntity.getSlotForHand((InteractionHand)living.getUsedItemHand()));
                tick = 0;
            }
            stack.set((DataComponentType)IafDataComponents.INT.get(), (Object)tick);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        super.appendHoverText(stack, context, tooltip, type);
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.legendary_weapon.desc").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.cyclops_eye.desc_0").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.iceandfire.cyclops_eye.desc_1").withStyle(ChatFormatting.GRAY));
    }
}

