/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.SeaSerpentEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class SeaSerpentAIMeleeJumpGoal
extends JumpGoal {
    private final SeaSerpentEntity dolphin;
    private int attackCooldown = 0;
    private boolean inWater;

    public SeaSerpentAIMeleeJumpGoal(SeaSerpentEntity dolphin) {
        this.dolphin = dolphin;
    }

    public boolean canUse() {
        return this.dolphin.getTarget() != null && this.dolphin.shouldUseJumpAttack(this.dolphin.getTarget()) && !this.dolphin.onGround();
    }

    public boolean canContinueToUse() {
        double d0 = this.dolphin.getDeltaMovement().y;
        return this.dolphin.getTarget() != null && this.dolphin.jumpCooldown > 0 && (d0 * d0 >= (double)0.03f || this.dolphin.getXRot() == 0.0f || Math.abs(this.dolphin.getXRot()) >= 10.0f || !this.dolphin.isInWater()) && !this.dolphin.onGround();
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        LivingEntity target = this.dolphin.getTarget();
        if (target != null) {
            double distanceXZ = this.dolphin.distanceToSqr(target.getX(), this.dolphin.getY(), target.getZ());
            if (distanceXZ < 300.0) {
                this.dolphin.lookAt((Entity)target, 260.0f, 30.0f);
                double smoothX = Mth.clamp((double)Math.abs(target.getX() - this.dolphin.getX()), (double)0.0, (double)1.0);
                double smoothZ = Mth.clamp((double)Math.abs(target.getZ() - this.dolphin.getZ()), (double)0.0, (double)1.0);
                double d0 = (target.getX() - this.dolphin.getX()) * 0.3 * smoothX;
                double d2 = (target.getZ() - this.dolphin.getZ()) * 0.3 * smoothZ;
                float up = 1.0f + this.dolphin.getRandom().nextFloat() * 0.8f;
                this.dolphin.setDeltaMovement(this.dolphin.getDeltaMovement().add(d0 * 0.3, (double)up, d2 * 0.3));
                this.dolphin.getNavigation().stop();
                this.dolphin.jumpCooldown = this.dolphin.getRandom().nextInt(32) + 32;
            } else {
                this.dolphin.getNavigation().moveTo((Entity)target, 1.0);
            }
        }
    }

    public void stop() {
        this.dolphin.setXRot(0.0f);
        this.attackCooldown = 0;
    }

    public void tick() {
        LivingEntity target;
        boolean flag = this.inWater;
        if (!flag) {
            FluidState fluidstate = this.dolphin.level().getFluidState(this.dolphin.blockPosition());
            this.inWater = fluidstate.is(FluidTags.WATER);
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.inWater && !flag) {
            this.dolphin.playSound(SoundEvents.DOLPHIN_JUMP, 1.0f, 1.0f);
        }
        if ((target = this.dolphin.getTarget()) != null) {
            if (this.dolphin.distanceTo((Entity)target) < 3.0f && this.attackCooldown <= 0) {
                this.attackCooldown = 20;
            } else if (this.dolphin.distanceTo((Entity)target) < 5.0f) {
                this.dolphin.setAnimation(SeaSerpentEntity.ANIMATION_BITE);
            }
        }
        Vec3 vector3d = this.dolphin.getDeltaMovement();
        if (vector3d.y * vector3d.y < (double)0.1f && this.dolphin.getXRot() != 0.0f || vector3d.length() == 0.0) {
            this.dolphin.setXRot(Mth.rotLerp((float)this.dolphin.getXRot(), (float)0.0f, (float)0.2f));
        } else {
            double d0 = vector3d.horizontalDistance();
            double d1 = Math.signum(-vector3d.y) * Math.acos(d0 / vector3d.length()) * 57.2957763671875;
            this.dolphin.setXRot((float)d1);
        }
    }
}

