/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.ai;

import com.iafenvoy.iceandfire.entity.DragonBaseEntity;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.uranus.object.item.FoodUtils;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class DragonAITargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    private final DragonBaseEntity dragon;

    public DragonAITargetGoal(DragonBaseEntity entityIn, Class<T> classTarget, boolean checkSight, Predicate<LivingEntity> targetSelector) {
        super((Mob)entityIn, classTarget, 3, checkSight, false, targetSelector);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.dragon = entityIn;
    }

    public boolean canUse() {
        if (this.dragon.getCommand() == 1 || this.dragon.getCommand() == 2 || this.dragon.isSleeping()) {
            return false;
        }
        if (!this.dragon.isTame() && this.dragon.lookingForRoostAIFlag) {
            return false;
        }
        if (this.target != null && !this.target.getClass().equals(this.dragon.getClass())) {
            if (!super.canUse()) {
                return false;
            }
            float dragonSize = Math.max(this.dragon.getBbWidth(), this.dragon.getBbWidth() * this.dragon.getRenderSize());
            if (dragonSize >= this.target.getBbWidth()) {
                LivingEntity livingEntity = this.target;
                Objects.requireNonNull(livingEntity);
                LivingEntity livingEntity2 = livingEntity;
                int n = 0;
                block5: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Player.class, DragonBaseEntity.class, Player.class}, (Object)livingEntity2, n)) {
                        case 0: {
                            Player ignored = (Player)livingEntity2;
                            if (this.dragon.isTame()) {
                                n = 1;
                                continue block5;
                            }
                            return true;
                        }
                        case 1: {
                            DragonBaseEntity d = (DragonBaseEntity)livingEntity2;
                            if (d.getOwner() != null && this.dragon.getOwner() != null && this.dragon.isOwnedBy(d.getOwner())) {
                                return false;
                            }
                            return !d.isModelDead();
                        }
                        case 2: {
                            Player ignored = (Player)livingEntity2;
                            if (!this.dragon.isTame()) {
                                n = 3;
                                continue block5;
                            }
                            return false;
                        }
                    }
                    break;
                }
                if (!this.dragon.isOwnedBy(this.target) && FoodUtils.getFoodPoints((Entity)this.target) > 0 && this.dragon.canMove() && (this.dragon.getHunger() < 90 || !this.dragon.isTame() && this.target instanceof Player)) {
                    if (this.dragon.isTame()) {
                        return DragonUtils.canTameDragonAttack(this.dragon, (Entity)this.target);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    protected AABB getTargetSearchArea(double targetDistance) {
        return this.dragon.getBoundingBox().inflate(targetDistance, targetDistance, targetDistance);
    }

    protected double getFollowDistance() {
        AttributeInstance iattributeinstance = this.mob.getAttribute(Attributes.FOLLOW_RANGE);
        return iattributeinstance == null ? 64.0 : iattributeinstance.getValue();
    }
}

