/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.impl.ComponentManager;
import com.iafenvoy.iceandfire.util.attachment.NeedUpdateData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ChainData
extends NeedUpdateData<LivingEntity> {
    public static final Codec<ChainData> CODEC = RecordCodecBuilder.create(i -> i.group((App)UUIDUtil.AUTHLIB_CODEC.listOf().fieldOf("chainedTo").forGetter(ChainData::getChainedTo)).apply((Applicative)i, ChainData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChainData> PACKET_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    @NotNull
    private final List<UUID> chainedTo = new LinkedList<UUID>();

    public ChainData() {
    }

    private ChainData(List<UUID> chainedTo) {
        this.chainedTo.addAll(chainedTo);
    }

    @Override
    public void tick(LivingEntity entity) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            for (UUID uuid : this.chainedTo) {
                double distance;
                Entity chain = world.getEntity(uuid);
                if (chain == null || !((distance = (double)chain.distanceTo((Entity)entity)) > 7.0)) continue;
                double x = (chain.getX() - entity.getX()) / distance;
                double y = (chain.getY() - entity.getY()) / distance;
                double z = (chain.getZ() - entity.getZ()) / distance;
                entity.setDeltaMovement(entity.getDeltaMovement().add(x * Math.abs(x) * 0.4, y * Math.abs(y) * 0.2, z * Math.abs(z) * 0.4));
            }
        }
    }

    @NotNull
    public List<UUID> getChainedTo() {
        return List.copyOf(this.chainedTo);
    }

    public void clearChains() {
        this.chainedTo.clear();
        this.markDirty();
    }

    public void attachChain(UUID chain) {
        if (this.chainedTo.contains(chain)) {
            return;
        }
        this.chainedTo.add(chain);
        this.markDirty();
    }

    public void removeChain(UUID chain) {
        this.chainedTo.remove(chain);
        this.markDirty();
    }

    public boolean isChainedTo(UUID toCheck) {
        return this.chainedTo.contains(toCheck);
    }

    public static ChainData get(LivingEntity living) {
        return ComponentManager.getChainData(living);
    }
}

