/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.util;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.compat.CuriosCompat;
import de.melanx.skyblockbuilder.config.StartingInventory;
import de.melanx.skyblockbuilder.config.common.CustomizationConfig;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.registration.ModBlocks;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.UsernameCache;

public class RandomUtility {
    public static void dropInventories(Player player) {
        if (player.isSpectator() || player.isCreative()) {
            return;
        }
        player.getInventory().dropAll();
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.dropInventory(player);
        }
    }

    public static void setStartInventory(ServerPlayer player) {
        if (player.isSpectator() || player.isCreative()) {
            return;
        }
        StartingInventory.getStarterItems().forEach(entry -> {
            if (entry.getLeft() == EquipmentSlot.MAINHAND) {
                player.getInventory().add(((ItemStack)entry.getRight()).copy());
            } else {
                player.setItemSlot((EquipmentSlot)entry.getLeft(), ((ItemStack)entry.getRight()).copy());
            }
        });
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.setStartInventory((Player)player);
        }
    }

    public static Component getFormattedPos(BlockPos pos) {
        return ComponentUtils.wrapInSquareBrackets((Component)Component.translatable((String)"chat.coordinates", (Object[])new Object[]{pos.getX(), pos.getY(), pos.getZ()}).withStyle(style -> style.withColor(ChatFormatting.GREEN).withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + pos.getX() + " " + pos.getY() + " " + pos.getZ())).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.translatable((String)"chat.coordinates.tooltip")))));
    }

    public static String formattedCooldown(long ticks) {
        int realTime = (int)(ticks / 20L);
        int min = realTime / 60;
        String sec = String.format("%02d", realTime % 60);
        return String.format("%s:%s", min, sec);
    }

    public static void deleteTeamIfEmpty(SkyblockSavedData data, Team team) {
        if (team.isEmpty() && CustomizationConfig.deleteTeamsAutomatically) {
            data.deleteTeam(team.getId());
            SkyblockBuilder.getLogger().info("Team {} ({}) was deleted. No player left.", (Object)team.getName(), (Object)team.getId());
        }
    }

    public static Set<GameProfile> getGameProfiles(ServerLevel level) {
        MinecraftServer server = level.getServer();
        GameProfileCache profileCache = server.getProfileCache();
        HashSet<GameProfile> profiles = new HashSet<GameProfile>();
        HashSet cachedIds = new HashSet();
        profileCache.load().forEach(info -> {
            GameProfile gp = info.getProfile();
            if (gp.getId().equals(Util.NIL_UUID)) {
                return;
            }
            profiles.add(gp);
            cachedIds.add(gp.getId());
        });
        int cachedProfilesAmount = cachedIds.size();
        HashSet<UUID> usedCachedIds = new HashSet<UUID>();
        int uncachedProfilesAmount = 0;
        int totalProfilesAmount = 0;
        for (Team team : SkyblockSavedData.get((Level)level).getTeams()) {
            for (UUID id : team.getPlayers()) {
                if (id.equals(Util.NIL_UUID)) continue;
                ++totalProfilesAmount;
                if (cachedIds.contains(id)) {
                    usedCachedIds.add(id);
                    continue;
                }
                String lastKnownUsername = UsernameCache.getLastKnownUsername((UUID)id);
                if (lastKnownUsername != null) {
                    profiles.add(new GameProfile(id, lastKnownUsername));
                    ++uncachedProfilesAmount;
                    continue;
                }
                Optional cachedNow = profileCache.get(id);
                if (cachedNow.isPresent()) {
                    profiles.add((GameProfile)cachedNow.get());
                    ++uncachedProfilesAmount;
                    continue;
                }
                ++uncachedProfilesAmount;
                boolean enforceProfileSecurity = CustomizationConfig.forceUnsecureProfileNames || server.enforceSecureProfile();
                GameProfile fetched = RandomUtility.fetchProfileOrUnknown(server, id, enforceProfileSecurity);
                profileCache.add(fetched);
                profiles.add(fetched);
            }
        }
        int usedCachedProfilesAmount = usedCachedIds.size();
        int unusedCachedProfilesAmount = cachedProfilesAmount - usedCachedProfilesAmount;
        SkyblockBuilder.getLogger().info("Cached profiles: {} ({} unused), uncached profiles: {}, total profiles: {}", new Object[]{cachedProfilesAmount, unusedCachedProfilesAmount, uncachedProfilesAmount, totalProfilesAmount});
        return profiles;
    }

    private static GameProfile fetchProfileOrUnknown(MinecraftServer server, UUID id, boolean enforceSecure) {
        GameProfile unnamed = new GameProfile(id, "Unknown");
        try {
            ProfileResult result = server.getSessionService().fetchProfile(id, enforceSecure);
            return result != null ? result.profile() : unnamed;
        }
        catch (IllegalArgumentException ex) {
            SkyblockBuilder.getLogger().error("Problems filling profile properties for id {} with requiring secure {}", (Object)id, (Object)enforceSecure);
            return unnamed;
        }
    }

    public static Set<TemplatesConfig.Spawn> fillTemplateFromWorld(StructureTemplate template, Level level, BlockPos pos, Vec3i box, boolean withEntities, Collection<Block> toIgnore) {
        HashSet<TemplatesConfig.Spawn> spawns = new HashSet<TemplatesConfig.Spawn>();
        if (box.getX() >= 1 && box.getY() >= 1 && box.getZ() >= 1) {
            BlockPos blockpos = pos.offset(box).offset(-1, -1, -1);
            ArrayList specialBlocks = Lists.newArrayList();
            ArrayList blocksWithTag = Lists.newArrayList();
            ArrayList normalBlocks = Lists.newArrayList();
            BlockPos minPos = new BlockPos(Math.min(pos.getX(), blockpos.getX()), Math.min(pos.getY(), blockpos.getY()), Math.min(pos.getZ(), blockpos.getZ()));
            BlockPos maxPos = new BlockPos(Math.max(pos.getX(), blockpos.getX()), Math.max(pos.getY(), blockpos.getY()), Math.max(pos.getZ(), blockpos.getZ()));
            template.size = box;
            for (BlockPos actPos : BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos)) {
                BlockEntity blockEntity;
                BlockPos relPos = actPos.subtract((Vec3i)minPos);
                BlockState state = level.getBlockState(actPos);
                if (!toIgnore.isEmpty() && toIgnore.contains(state.getBlock())) continue;
                if (state.is(ModBlocks.spawnBlock)) {
                    WorldUtil.SpawnDirection direction = WorldUtil.SpawnDirection.fromDirection((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING));
                    spawns.add(new TemplatesConfig.Spawn(relPos, direction));
                    if (toIgnore.contains(Blocks.AIR)) continue;
                    state = Blocks.AIR.defaultBlockState();
                }
                StructureTemplate.StructureBlockInfo blockInfo = (blockEntity = level.getBlockEntity(actPos)) != null ? new StructureTemplate.StructureBlockInfo(relPos, state, blockEntity.saveWithId((HolderLookup.Provider)level.registryAccess())) : new StructureTemplate.StructureBlockInfo(relPos, state, null);
                StructureTemplate.addToLists((StructureTemplate.StructureBlockInfo)blockInfo, (List)specialBlocks, (List)blocksWithTag, (List)normalBlocks);
            }
            List sortedBlocks = StructureTemplate.buildInfoList((List)specialBlocks, (List)blocksWithTag, (List)normalBlocks);
            template.palettes.clear();
            template.palettes.add(new StructureTemplate.Palette(sortedBlocks));
            if (withEntities) {
                template.fillEntityList(level, minPos, maxPos.offset(1, 1, 1));
            } else {
                template.entityInfoList.clear();
            }
        }
        return spawns;
    }

    public static String normalize(String s) {
        return FileUtil.sanitizeName((String)s.toLowerCase(Locale.ROOT));
    }

    public static Path getFilePath(Path parentFolder, String name, String extension) {
        String filename;
        Path filepath;
        int index = 0;
        do {
            filename = (name == null || name.isBlank() ? "template" : RandomUtility.normalize(name)) + (String)(index == 0 ? "" : "_" + index) + "." + extension;
            ++index;
        } while (Files.exists(filepath = parentFolder.resolve(filename), new LinkOption[0]));
        return filepath;
    }

    public static String shorten(@Nonnull Font font, String name, int length) {
        Object s = name;
        int k = 0;
        while (font.width((String)s) > length) {
            s = name.substring(0, name.length() - k).trim() + "...";
            ++k;
        }
        return s;
    }
}

