/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.network;

import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.item.StructureSaverSettings;
import de.melanx.skyblockbuilder.registration.ModDataComponentTypes;
import javax.annotation.Nonnull;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.HandlerThread;
import org.moddingx.libx.network.PacketHandler;

public class UpdateStructureSaverSettingsHandler
extends PacketHandler<Message> {
    public static final CustomPacketPayload.Type<Message> TYPE = new CustomPacketPayload.Type(SkyblockBuilder.getInstance().resource("update_structure_saver_settings"));

    protected UpdateStructureSaverSettingsHandler() {
        super(TYPE, PacketFlow.SERVERBOUND, Message.CODEC, HandlerThread.MAIN);
    }

    public void handle(Message msg, IPayloadContext ctx) {
        Player player = ctx.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            player2.getMainHandItem().set(ModDataComponentTypes.structureSaverSettings, (Object)msg.settings);
        }
    }

    public record Message(ItemStack stack, StructureSaverSettings settings) implements CustomPacketPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Message> CODEC = StreamCodec.of((buffer, msg) -> {
            ItemStack.STREAM_CODEC.encode(buffer, (Object)msg.stack);
            StructureSaverSettings.STREAM_CODEC.encode(buffer, (Object)msg.settings);
        }, buffer -> {
            ItemStack stack = (ItemStack)ItemStack.STREAM_CODEC.decode(buffer);
            StructureSaverSettings settings = (StructureSaverSettings)StructureSaverSettings.STREAM_CODEC.decode(buffer);
            return new Message(stack, settings);
        });

        @Nonnull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }
    }
}

