/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.values.providers;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.values.TemplateSurroundingBlocks;

public interface SurroundingBlocksProvider {
    public static final SurroundingBlocksProvider EMPTY = new Direct(TemplateSurroundingBlocks.EMPTY);

    public TemplateSurroundingBlocks templateSurroundingBlocks();

    public JsonElement toJson();

    public boolean isEmpty();

    public static SurroundingBlocksProvider fromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            return new Reference(json.getAsString());
        }
        if (json.isJsonObject()) {
            return new Direct(TemplateSurroundingBlocks.fromJson(json.getAsJsonObject()));
        }
        throw new IllegalArgumentException("Unknown surrounding blocks: " + String.valueOf(json));
    }

    public record Reference(String name) implements SurroundingBlocksProvider
    {
        @Override
        public TemplateSurroundingBlocks templateSurroundingBlocks() {
            if (!TemplatesConfig.surroundingBlockReferences.containsKey(this.name)) {
                throw new IllegalArgumentException("Unknown surrounding blocks: " + this.name);
            }
            return TemplatesConfig.surroundingBlockReferences.get(this.name);
        }

        @Override
        public JsonElement toJson() {
            return new JsonPrimitive(this.name);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }
    }

    public record Direct(TemplateSurroundingBlocks templateSurroundingBlocks) implements SurroundingBlocksProvider
    {
        @Override
        public JsonElement toJson() {
            return TemplateSurroundingBlocks.toJson(this.templateSurroundingBlocks);
        }

        @Override
        public boolean isEmpty() {
            return this.templateSurroundingBlocks.blocks().isEmpty() || this.templateSurroundingBlocks.margin() == 0;
        }
    }
}

