/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.config.mapper;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.moddingx.libx.config.gui.ConfigEditor;
import org.moddingx.libx.config.gui.InputProperties;
import org.moddingx.libx.config.mapper.ValueMapper;
import org.moddingx.libx.config.validator.ValidatorInfo;

public class BlockMapper
implements ValueMapper<Block, JsonElement> {
    private static final InputProperties<Block> INPUT = new InputProperties<Block>(){

        public Block defaultValue() {
            return Blocks.AIR;
        }

        public Block valueOf(String str) {
            return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)str));
        }

        public boolean canInputChar(char chr) {
            return ResourceLocation.isAllowedInResourceLocation((char)chr);
        }

        public boolean isValid(String str) {
            ResourceLocation id = ResourceLocation.tryParse((String)str);
            return id != null && BuiltInRegistries.BLOCK.containsKey(id);
        }

        public String toString(Block block) {
            return BuiltInRegistries.BLOCK.getKey((Object)block).toString();
        }
    };

    public Class<Block> type() {
        return Block.class;
    }

    public Class<JsonElement> element() {
        return JsonElement.class;
    }

    public Block fromJson(JsonElement json) {
        return (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)json.getAsString()));
    }

    public JsonElement toJson(Block value) {
        return new JsonPrimitive(BuiltInRegistries.BLOCK.getKey((Object)value).toString());
    }

    public ConfigEditor<Block> createEditor(ValidatorInfo<?> validator) {
        return ConfigEditor.input(INPUT);
    }
}

