/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.team;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.events.SkyblockHooks;
import de.melanx.skyblockbuilder.events.SkyblockJoinRequestEvent;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.CommandUtil;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class JoinRequestHandlingCommand {
    static ArgumentBuilder<CommandSourceStack, ?> registerAccept() {
        return Commands.literal((String)"accept").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).suggests(Suggestions.INVITED_PLAYERS_OF_PLAYERS_TEAM).executes(context -> JoinRequestHandlingCommand.acceptRequest((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"))));
    }

    static ArgumentBuilder<CommandSourceStack, ?> registerDeny() {
        return Commands.literal((String)"deny").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).suggests(Suggestions.INVITED_PLAYERS_OF_PLAYERS_TEAM).executes(context -> JoinRequestHandlingCommand.denyRequest((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)"player"))));
    }

    private static int acceptRequest(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = JoinRequestHandlingCommand.checkJoinRequestValidity(source, player);
        if (validationResult == null) {
            return 0;
        }
        SkyblockJoinRequestEvent.AcceptRequest event = SkyblockHooks.onAcceptJoinRequest(validationResult.player(), player, validationResult.team());
        switch (event.getResult()) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_ACCEPT_JOIN_REQUEST);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_HANDLE_JOIN_REQUESTS)) break;
                source.sendFailure((Component)SkyComponents.DISABLED_ACCEPT_JOIN_REQUEST);
                return 0;
            }
        }
        validationResult.team().broadcast(SkyComponents.EVENT_ACCEPT_JOIN_REQUEST.apply(validationResult.player().getDisplayName(), player.getDisplayName()), Style.EMPTY.applyFormat(ChatFormatting.GOLD));
        validationResult.data().addPlayerToTeam(validationResult.team(), (Player)player);
        validationResult.team().removeJoinRequest((Player)player);
        WorldUtil.teleportToIsland(player, validationResult.team());
        player.displayClientMessage((Component)SkyComponents.SUCCESS_JOIN_REQUEST_ACCEPTED.apply(validationResult.team().getName()), false);
        return 1;
    }

    private static int denyRequest(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        CommandUtil.ValidationResult validationResult = JoinRequestHandlingCommand.checkJoinRequestValidity(source, player);
        if (validationResult == null) {
            return 0;
        }
        Team team = validationResult.team();
        SkyblockJoinRequestEvent.DenyRequest event = SkyblockHooks.onDenyJoinRequest(validationResult.player(), player, team);
        switch (event.getResult()) {
            case DENY: {
                source.sendFailure((Component)SkyComponents.DENIED_DENY_JOIN_REQUEST);
                return 0;
            }
            case DEFAULT: {
                if (PermissionManager.INSTANCE.hasPermission((Player)player, PermissionManager.Permission.TEAM_HANDLE_JOIN_REQUESTS)) break;
                source.sendFailure((Component)SkyComponents.DISABLED_DENY_JOIN_REQUEST);
                return 0;
            }
        }
        team.broadcast(SkyComponents.EVENT_DENY_JOIN_REQUEST.apply(validationResult.player().getDisplayName(), player.getDisplayName()), Style.EMPTY.applyFormat(ChatFormatting.GOLD));
        team.removeJoinRequest((Player)player);
        player.displayClientMessage((Component)SkyComponents.SUCCESS_DENY_REQUEST_ACCEPTED.apply(team.getName()), false);
        return 1;
    }

    @Nullable
    private static CommandUtil.ValidationResult checkJoinRequestValidity(CommandSourceStack source, ServerPlayer player) throws CommandSyntaxException {
        CommandUtil.ValidationResult result = CommandUtil.validatePlayerTeam(source);
        if (result == null) {
            return null;
        }
        if (result.data().hasPlayerTeam((Player)player)) {
            source.sendFailure((Component)SkyComponents.ERROR_PLAYER_HAS_TEAM.apply(player.getDisplayName().toString()));
            result.team().removeJoinRequest((Player)player);
            return null;
        }
        return result;
    }
}

