/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.permissions.PermissionManager;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyComponents;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class SpawnsCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"spawns").executes(context -> SpawnsCommand.showSpawns((CommandSourceStack)context.getSource()));
    }

    private static int showSpawns(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.getLevel();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = null;
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            team = data.getTeamFromPlayer((Player)player);
        }
        if (team == null) {
            team = data.getSpawn();
        }
        if (team.isSpawn() && !PermissionManager.INSTANCE.mayExecuteOpCommand(source)) {
            source.sendFailure((Component)SkyComponents.ERROR_USER_HAS_NO_TEAM);
            return 0;
        }
        Set<TemplatesConfig.Spawn> spawns = team.getPossibleSpawns();
        if (!spawns.isEmpty()) {
            source.sendSystemMessage((Component)SkyComponents.INFO_SHOW_TEAM_SPAWNS.apply(team.getName()));
        }
        for (TemplatesConfig.Spawn spawn : spawns) {
            BlockPos pos = spawn.pos();
            source.sendSystemMessage((Component)Component.literal((String)" - ").append(RandomUtility.getFormattedPos(pos)));
            Entity entity2 = source.getEntity();
            if (entity2 instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity2;
                level.sendParticles(player, (ParticleOptions)ParticleTypes.HAPPY_VILLAGER, true, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.1, 0.1, 0.1, 10.0);
                continue;
            }
            level.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 5, 0.1, 0.1, 0.1, 10.0);
        }
        return 1;
    }
}

