/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.mover.items;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleDataString;
import mcjty.rftoolsbuilder.modules.mover.MoverConfiguration;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverControllerTileEntity;
import mcjty.rftoolsbuilder.modules.mover.blocks.MoverTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record VehicleStatusScreenModule(GlobalPos pos, String label, String vehicle, String monitor, TextAlign align, int labelColor, int color) implements IScreenModule<VehicleStatusScreenModule, IModuleDataString>
{
    public static final VehicleStatusScreenModule DEFAULT = new VehicleStatusScreenModule(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID), "", "", "", TextAlign.ALIGN_LEFT, 0xFFFFFF, 0xFFFFFF);
    public static final Codec<VehicleStatusScreenModule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(module -> module.pos), (App)Codec.STRING.fieldOf("label").forGetter(module -> module.label), (App)Codec.STRING.fieldOf("vehicle").forGetter(module -> module.vehicle), (App)Codec.STRING.fieldOf("monitor").forGetter(module -> module.monitor), (App)TextAlign.CODEC.fieldOf("align").forGetter(module -> module.align), (App)Codec.INT.fieldOf("labelColor").forGetter(module -> module.labelColor), (App)Codec.INT.fieldOf("color").forGetter(module -> module.color)).apply((Applicative)instance, VehicleStatusScreenModule::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, VehicleStatusScreenModule> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)GlobalPos.STREAM_CODEC, module -> module.pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.label, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.vehicle, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.monitor, (StreamCodec)TextAlign.STREAM_CODEC, module -> module.align, (StreamCodec)ByteBufCodecs.INT, module -> module.labelColor, (StreamCodec)ByteBufCodecs.INT, module -> module.color, VehicleStatusScreenModule::new);

    public GlobalPos getPos() {
        return this.pos;
    }

    public String getLabel() {
        return this.label;
    }

    public String getVehicle() {
        return this.vehicle;
    }

    public String getMonitor() {
        return this.monitor;
    }

    public TextAlign getAlign() {
        return this.align;
    }

    public int getLabelColor() {
        return this.labelColor;
    }

    public int getColor() {
        return this.color;
    }

    public VehicleStatusScreenModule withLabel(String label) {
        return new VehicleStatusScreenModule(this.pos, label, this.vehicle, this.monitor, this.align, this.labelColor, this.color);
    }

    public VehicleStatusScreenModule withVehicle(String vehicle) {
        return new VehicleStatusScreenModule(this.pos, this.label, vehicle, this.monitor, this.align, this.labelColor, this.color);
    }

    public VehicleStatusScreenModule withMonitor(String monitor) {
        return new VehicleStatusScreenModule(this.pos, this.label, this.vehicle, monitor, this.align, this.labelColor, this.color);
    }

    public VehicleStatusScreenModule withAlign(TextAlign align) {
        return new VehicleStatusScreenModule(this.pos, this.label, this.vehicle, this.monitor, align, this.labelColor, this.color);
    }

    public VehicleStatusScreenModule withLabelColor(int labelColor) {
        return new VehicleStatusScreenModule(this.pos, this.label, this.vehicle, this.monitor, this.align, labelColor, this.color);
    }

    public VehicleStatusScreenModule withColor(int color) {
        return new VehicleStatusScreenModule(this.pos, this.label, this.vehicle, this.monitor, this.align, this.labelColor, color);
    }

    public VehicleStatusScreenModule withPos(GlobalPos pos) {
        return new VehicleStatusScreenModule(pos, this.label, this.vehicle, this.monitor, this.align, this.labelColor, this.color);
    }

    public IModuleDataString getData(IScreenDataHelper helper, Level level, long millis) {
        String mover = VehicleStatusScreenModule.getMoverController(level, (ResourceKey<Level>)this.pos.dimension(), this.pos.pos()).map(c -> {
            MoverTileEntity m = c.findVehicle(this.vehicle);
            if (m != null) {
                return m.getName();
            }
            return "<unknown>";
        }).orElse("<unknown>");
        return helper.createString(mover);
    }

    public VehicleStatusScreenModule validate(Level world, BlockPos pos, boolean isPlus) {
        return this;
    }

    public int getRfPerTick() {
        return (Integer)MoverConfiguration.VEHICLE_STATUS_RFPERTICK.get();
    }

    public ItemStack mouseClick(ItemStack moduleStack, Level world, int x, int y, boolean clicked, Player player) {
        return ItemStack.EMPTY;
    }

    public static Optional<MoverControllerTileEntity> getMoverController(Level worldObj, ResourceKey<Level> dim, BlockPos coordinate) {
        ServerLevel world = LevelTools.getLevel((Level)worldObj, dim);
        if (world == null) {
            return Optional.empty();
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)coordinate)) {
            return Optional.empty();
        }
        BlockEntity te = world.getBlockEntity(coordinate);
        if (te == null) {
            return Optional.empty();
        }
        if (!(te instanceof MoverControllerTileEntity)) {
            return Optional.empty();
        }
        return Optional.of((MoverControllerTileEntity)te);
    }
}

