/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.machine;

import com.jerry.mekmm.common.attachments.component.ConnectionConfig;
import com.jerry.mekmm.common.attachments.component.WirelessConnectionManager;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.inventory.container.tile.WirelessTransmissionStationConfigContainer;
import com.jerry.mekmm.common.registries.MoreMachineBlocks;
import com.jerry.mekmm.common.registries.MoreMachineDataComponents;
import com.jerry.mekmm.common.tile.interfaces.ITileConnectHolder;
import com.jerry.mekmm.common.tile.prefab.TileEntityConnectableMachine;
import java.util.HashSet;
import java.util.List;
import java.util.function.DoubleSupplier;
import java.util.function.Predicate;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.heat.HeatAPI;
import mekanism.api.heat.IHeatCapacitor;
import mekanism.api.heat.IHeatHandler;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.heat.BasicHeatCapacitor;
import mekanism.common.capabilities.heat.CachedAmbientTemperature;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.heat.HeatCapacitorHelper;
import mekanism.common.capabilities.holder.heat.IHeatCapacitorHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.content.network.transmitter.LogisticalTransporterBase;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableDouble;
import mekanism.common.inventory.container.sync.SyncableInt;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.inventory.Finder;
import mekanism.common.lib.inventory.TransitRequest;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.util.CableUtils;
import mekanism.common.util.ChemicalUtil;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityWirelessTransmissionStation
extends TileEntityConnectableMachine
implements IBoundingBlock,
ITileConnectHolder {
    public static final long DEFAULT_ENERGY_RATE = 0L;
    public static final int DEFAULT_FLUIDS_RATE = 0;
    public static final long DEFAULT_CHEMICALS_RATE = 0L;
    public static final int DEFAULT_ITEMS_RATE = 0;
    public final WirelessConnectionManager connectionManager = new WirelessConnectionManager(this);
    private long energyRate = 0L;
    private int fluidsRate = 0;
    private long chemicalsRate = 0L;
    private int itemsRate = 0;
    public static final long MAX_CHEMICAL = 10000L;
    public static final int MAX_FLUID = 10000;
    public static final double HEAT_CAPACITY = 10.0;
    public static final double INVERSE_CONDUCTION_COEFFICIENT = 2.0;
    public static final double INVERSE_INSULATION_COEFFICIENT = 100.0;
    public static final double MAX_MULTIPLIER_TEMP = 10000.0;
    private double lastTransferLoss;
    private double lastEnvironmentLoss;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"}, docPlaceholder="fluid tank")
    public BasicFluidTank fluidTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getChemical", "getChemicalCapacity", "getChemicalNeeded", "getChemicalFilledPercentage"}, docPlaceholder="chemical tank")
    public IChemicalTank chemicalTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getItemSlot"}, docPlaceholder="item slot")
    public BasicInventorySlot inventorySlot;
    public MachineEnergyContainer<TileEntityWirelessTransmissionStation> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerHeatCapacitorWrapper.class, methodNames={"getTemperature"}, docPlaceholder="transmission")
    public BasicHeatCapacitor heatCapacitor;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFluidFillItem"}, docPlaceholder="fill fluid slot")
    FluidInventorySlot fluidFillSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFluidDrainItem"}, docPlaceholder="drain fluid slot")
    FluidInventorySlot fluidDrainSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFluidItemOutput"}, docPlaceholder="fluid item output slot")
    OutputInventorySlot fluidOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalFillItem"}, docPlaceholder="fill chemical slot")
    ChemicalInventorySlot chemicalInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalDrainItem"}, docPlaceholder="drain chemical slot")
    ChemicalInventorySlot chemicalOutputSlot;
    EnergyInventorySlot energySlot;

    public TileEntityWirelessTransmissionStation(BlockPos pos, BlockState state) {
        super((Holder<Block>)MoreMachineBlocks.WIRELESS_TRANSMISSION_STATION, pos, state);
        this.configComponent.setupIOConfig(TransmissionType.ENERGY, this.energyContainer, RelativeSide.FRONT);
        this.configComponent.setupIOConfig(TransmissionType.FLUID, (Object)this.fluidTank, RelativeSide.LEFT);
        this.configComponent.setupIOConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank, RelativeSide.RIGHT);
        this.configComponent.setupItemIOConfig(List.of(this.inventorySlot, this.fluidFillSlot, this.chemicalInputSlot), List.of(this.fluidDrainSlot, this.chemicalOutputSlot, this.fluidOutputSlot), (IInventorySlot)this.energySlot, false);
        this.configComponent.setupIOConfig(TransmissionType.HEAT, (Object)this.heatCapacitor, RelativeSide.BACK);
        this.configComponent.addDisabledSides(new RelativeSide[]{RelativeSide.TOP});
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL, TransmissionType.FLUID, TransmissionType.ENERGY, TransmissionType.HEAT});
    }

    @Nullable
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig((ISideConfiguration)this);
        this.inventorySlot = BasicInventorySlot.at((IContentsListener)listener, (int)8, (int)77);
        builder.addSlot((IInventorySlot)this.inventorySlot);
        this.chemicalInputSlot = ChemicalInventorySlot.fill((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)28, (int)15);
        builder.addSlot((IInventorySlot)this.chemicalInputSlot);
        this.chemicalOutputSlot = ChemicalInventorySlot.drain((IChemicalTank)this.chemicalTank, (IContentsListener)listener, (int)28, (int)57);
        builder.addSlot((IInventorySlot)this.chemicalOutputSlot);
        this.fluidFillSlot = FluidInventorySlot.fill((IExtendedFluidTank)this.fluidTank, (IContentsListener)listener, (int)131, (int)15);
        builder.addSlot((IInventorySlot)this.fluidFillSlot);
        this.fluidDrainSlot = FluidInventorySlot.drain((IExtendedFluidTank)this.fluidTank, (IContentsListener)listener, (int)131, (int)57);
        builder.addSlot((IInventorySlot)this.fluidDrainSlot);
        this.fluidOutputSlot = OutputInventorySlot.at((IContentsListener)listener, (int)131, (int)36);
        builder.addSlot((IInventorySlot)this.fluidOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityWirelessTransmissionStation)this).getLevel(), (IContentsListener)listener, (int)28, (int)36);
        builder.addSlot((IInventorySlot)this.energySlot);
        this.chemicalInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.chemicalOutputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.fluidFillSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.fluidDrainSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.chemicalTank = BasicChemicalTank.createModern((long)10000L, (Predicate)ConstantPredicates.alwaysTrue(), (Predicate)ConstantPredicates.alwaysTrue(), (IContentsListener)listener);
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @Nullable
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener) {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.fluidTank = BasicFluidTank.create((int)10000, (IContentsListener)listener);
        builder.addTank((IExtendedFluidTank)this.fluidTank);
        return builder.build();
    }

    @Nullable
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig((ISideConfiguration)this);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)listener);
        builder.addContainer((IEnergyContainer)this.energyContainer);
        return builder.build();
    }

    @Nullable
    protected IHeatCapacitorHolder getInitialHeatCapacitors(IContentsListener listener, CachedAmbientTemperature ambientTemperature) {
        HeatCapacitorHelper builder = HeatCapacitorHelper.forSideWithConfig((ISideConfiguration)this);
        this.heatCapacitor = BasicHeatCapacitor.create((double)10.0, (double)2.0, (double)100.0, (DoubleSupplier)ambientTemperature, (IContentsListener)listener);
        builder.addCapacitor((IHeatCapacitor)this.heatCapacitor);
        return builder.build();
    }

    private void closeInvalidScreens() {
        if (this.getActive() && !this.playersUsing.isEmpty()) {
            for (Player player : new HashSet(this.playersUsing)) {
                if (!(player.containerMenu instanceof WirelessTransmissionStationConfigContainer)) continue;
                player.closeContainer();
            }
        }
    }

    protected void onUpdateClient() {
        super.onUpdateClient();
        this.closeInvalidScreens();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.closeInvalidScreens();
        this.chemicalInputSlot.fillTank();
        this.chemicalOutputSlot.drainTank();
        this.fluidFillSlot.fillTank((IInventorySlot)this.fluidOutputSlot);
        this.fluidDrainSlot.drainTank((IInventorySlot)this.fluidOutputSlot);
        this.energySlot.fillContainerOrConvert();
        if (this.level != null && this.level.getGameTime() % 50L == 0L) {
            this.connectionManager.validateConnections();
        }
        CableUtils.emit(this.connectionManager.getEnergyCaches(), this.energyContainer, (long)this.getEnergyRate());
        FluidUtils.emit(this.connectionManager.getFluidCaches(), (IExtendedFluidTank)this.fluidTank, (int)this.getFluidsRate());
        ChemicalUtil.emit(this.connectionManager.getChemicalCaches(), (IChemicalTank)this.chemicalTank, (long)this.getChemicalsRate());
        this.transportItems();
        HeatAPI.HeatTransfer loss = this.simulate();
        this.lastTransferLoss = loss.adjacentTransfer();
        this.lastEnvironmentLoss = loss.environmentTransfer();
        return sendUpdatePacket;
    }

    private void transportItems() {
        if (this.itemsRate <= 0) {
            return;
        }
        IItemHandler selfHandler = (IItemHandler)Capabilities.ITEM.createCache((ServerLevel)this.level, this.getBlockPos(), Direction.DOWN).getCapability();
        if (selfHandler == null) {
            return;
        }
        for (BlockCapabilityCache<IItemHandler, Direction> cache : this.connectionManager.getItemCaches()) {
            TransitRequest.TransitResponse response;
            TransitRequest request;
            IItemHandler target = (IItemHandler)cache.getCapability();
            if (target == null || (request = TransitRequest.definedItem((IItemHandler)selfHandler, (int)1, (int)this.getItemsRate(), (Finder)Finder.ANY)).isEmpty() || (response = request.eject((BlockEntity)this, this.getBlockPos(), target, 0, LogisticalTransporterBase::getColor)).isEmpty()) continue;
            int amount = response.getSendingAmount();
            MekanismUtils.logMismatchedStackSize((long)this.inventorySlot.shrinkStack(amount, Action.EXECUTE), (long)amount);
        }
    }

    private double exchangeHeat() {
        double adjacentTransfer = 0.0;
        double totalHeatToTransfer = 0.0;
        double currentTemp = this.getTemperature();
        double heatCapacity = this.heatCapacitor.getHeatCapacity();
        for (ConnectionConfig config : this.connectionManager.getConnectionsByType(TransmissionType.HEAT)) {
            IHeatHandler sink = (IHeatHandler)WorldUtils.getCapability((Level)this.level, (BlockCapability)Capabilities.HEAT, (BlockPos)config.pos(), (Object)config.direction());
            if (sink == null) continue;
            double sinkTemp = sink.getTotalTemperature();
            double invConduction = sink.getTotalInverseConduction() + this.heatCapacitor.getInverseConduction();
            if (invConduction == 0.0) continue;
            double tempDifference = currentTemp - sinkTemp;
            double tempToTransfer = tempDifference / invConduction;
            double heatToTransfer = tempToTransfer * heatCapacity;
            double maxHeatTransfer = Math.abs(tempDifference) * heatCapacity * 0.5;
            heatToTransfer = Mth.clamp((double)heatToTransfer, (double)(-maxHeatTransfer), (double)maxHeatTransfer);
            totalHeatToTransfer -= heatToTransfer;
            sink.handleHeat(heatToTransfer);
            adjacentTransfer = this.incrementAdjacentTransfer(adjacentTransfer, tempToTransfer, config.direction());
        }
        if (totalHeatToTransfer != 0.0) {
            this.heatCapacitor.handleHeat(totalHeatToTransfer);
        }
        return adjacentTransfer;
    }

    public void setRemoved() {
        super.setRemoved();
        this.connectionManager.clear();
    }

    public double simulateAdjacent() {
        return super.simulateAdjacent() + this.exchangeHeat();
    }

    @Override
    public TileEntityConnectableMachine.ConnectStatus connectOrCut(BlockPos blockPos, Direction direction, TransmissionType type) {
        TileEntityConnectableMachine.ConnectStatus status = this.connectionManager.linkOrCut(blockPos, direction, type);
        if (status != TileEntityConnectableMachine.ConnectStatus.CONNECT_FAIL && !this.isRemote()) {
            this.sendUpdatePacket();
            this.markForSave();
        }
        return status;
    }

    @Nullable
    public MachineEnergyContainer<TileEntityWirelessTransmissionStation> getEnergyContainer() {
        return this.energyContainer;
    }

    public long getEnergyRate() {
        return this.energyRate;
    }

    public int getFluidsRate() {
        return this.fluidsRate;
    }

    public long getChemicalsRate() {
        return this.chemicalsRate;
    }

    public int getItemsRate() {
        return this.itemsRate;
    }

    public void setEnergyRateFromPacket(long newRate) {
        this.setEnergyRate(Mth.clamp((long)newRate, (long)0L, (long)MoreMachineConfig.general.energyRate.get()));
    }

    public void setEnergyRate(long newRate) {
        if (this.energyRate != newRate) {
            this.energyRate = newRate;
        }
    }

    public void setFluidsRateFromPacket(int newRate) {
        this.setFluidsRate(Mth.clamp((int)newRate, (int)0, (int)MoreMachineConfig.general.fluidsRate.get()));
    }

    public void setFluidsRate(int newRate) {
        if (this.fluidsRate != newRate) {
            this.fluidsRate = newRate;
        }
    }

    public void setChemicalsRateFromPacket(long newRate) {
        this.setChemicalsRate(Mth.clamp((long)newRate, (long)0L, (long)MoreMachineConfig.general.chemicalsRate.get()));
    }

    public void setChemicalsRate(long newRate) {
        if (this.chemicalsRate != newRate) {
            this.chemicalsRate = newRate;
        }
    }

    public void setItemsRateFromPacket(int newRate) {
        this.setItemsRate(Mth.clamp((int)newRate, (int)0, (int)MoreMachineConfig.general.itemsRate.get()));
    }

    public void setItemsRate(int newRate) {
        if (this.itemsRate != newRate) {
            this.itemsRate = newRate;
        }
    }

    public double getTemperature() {
        return this.heatCapacitor.getTemperature();
    }

    public double getLastTransferLoss() {
        return this.lastTransferLoss;
    }

    public double getLastEnvironmentLoss() {
        return this.lastEnvironmentLoss;
    }

    @NotNull
    public CompoundTag getReducedUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag updateTag = super.getReducedUpdateTag(provider);
        this.connectionManager.saveToNBT(updateTag);
        updateTag.putLong("energy_rate", this.getEnergyRate());
        updateTag.putInt("fluids_rate", this.getFluidsRate());
        updateTag.putLong("chemicals_rate", this.getChemicalsRate());
        updateTag.putInt("item_rate", this.getItemsRate());
        return updateTag;
    }

    public void handleUpdateTag(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.handleUpdateTag(tag, provider);
        this.connectionManager.loadFromNBT(tag);
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"energy_rate", this::setEnergyRate);
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"fluids_rate", this::setFluidsRate);
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"chemicals_rate", this::setChemicalsRate);
        NBTUtils.setIntIfPresent((CompoundTag)tag, (String)"item_rate", this::setItemsRate);
    }

    public void readSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        this.setEnergyRate(Math.min((long)dataMap.getInt("energy_rate"), MoreMachineConfig.general.energyRate.get()));
        this.setFluidsRate(Math.min(dataMap.getInt("fluids_rate"), MoreMachineConfig.general.fluidsRate.get()));
        this.setChemicalsRate(Math.min((long)dataMap.getInt("chemicals_rate"), MoreMachineConfig.general.chemicalsRate.get()));
        this.setItemsRate(Math.min(dataMap.getInt("item_rate"), MoreMachineConfig.general.itemsRate.get()));
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        dataMap.putLong("energy_rate", this.getEnergyRate());
        dataMap.putInt("fluids_rate", this.getFluidsRate());
        dataMap.putLong("chemicals_rate", this.getChemicalsRate());
        dataMap.putInt("item_rate", this.getItemsRate());
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(nbt, provider);
        this.connectionManager.loadFromNBT(nbt);
    }

    public void saveAdditional(@NotNull CompoundTag nbtTags, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(nbtTags, provider);
        this.connectionManager.saveToNBT(nbtTags);
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        this.addConfigContainerTrackers(container);
        container.track((ISyncableData)SyncableDouble.create(this::getLastTransferLoss, value -> {
            this.lastTransferLoss = value;
        }));
        container.track((ISyncableData)SyncableDouble.create(this::getLastEnvironmentLoss, value -> {
            this.lastEnvironmentLoss = value;
        }));
        container.track((ISyncableData)SyncableInt.create(this.connectionManager::getConnectionCount, count -> {}));
    }

    public void addConfigContainerTrackers(MekanismContainer container) {
        container.track((ISyncableData)SyncableLong.create(this::getEnergyRate, this::setEnergyRate));
        container.track((ISyncableData)SyncableInt.create(this::getFluidsRate, this::setFluidsRate));
        container.track((ISyncableData)SyncableLong.create(this::getChemicalsRate, this::setChemicalsRate));
        container.track((ISyncableData)SyncableInt.create(this::getItemsRate, this::setItemsRate));
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set(MoreMachineDataComponents.ENERGY_RATE, (Object)this.getEnergyRate());
        builder.set(MoreMachineDataComponents.FLUIDS_RATE, (Object)this.getFluidsRate());
        builder.set(MoreMachineDataComponents.CHEMICALS_RATE, (Object)this.getChemicalsRate());
        builder.set(MoreMachineDataComponents.ITEMS_RATE, (Object)this.getItemsRate());
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.setEnergyRate(Math.min((Long)input.getOrDefault(MoreMachineDataComponents.ENERGY_RATE, (Object)this.energyRate), MoreMachineConfig.general.energyRate.get()));
        this.setFluidsRate(Math.min((Integer)input.getOrDefault(MoreMachineDataComponents.FLUIDS_RATE, (Object)this.fluidsRate), MoreMachineConfig.general.fluidsRate.get()));
        this.setChemicalsRate(Math.min((Long)input.getOrDefault(MoreMachineDataComponents.CHEMICALS_RATE, (Object)this.chemicalsRate), MoreMachineConfig.general.chemicalsRate.get()));
        this.setItemsRate(Math.min((Integer)input.getOrDefault(MoreMachineDataComponents.ITEMS_RATE, (Object)this.itemsRate), MoreMachineConfig.general.itemsRate.get()));
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.energyContainer.getEnergy(), (long)this.energyContainer.getMaxEnergy());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.ENERGY;
    }

    @Override
    public WirelessConnectionManager getConnectManager() {
        return this.connectionManager;
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Set energy output rate")
    void computerSetEnergyRate(long rate) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.energyRate != rate) {
            this.energyRate = rate;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Set fluids output rate")
    void computerSetFluidsRate(int rate) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.fluidsRate != rate) {
            this.fluidsRate = rate;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Set chemicals output rate")
    void computerSetChemicalsRate(long rate) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.chemicalsRate != rate) {
            this.chemicalsRate = rate;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Set items output rate")
    void computerSetItemsRate(int rate) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.itemsRate != rate) {
            this.itemsRate = rate;
            this.markForSave();
        }
    }
}

