/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.tile.factory;

import com.jerry.mekmm.api.recipes.basic.MMBasicItemStackChemicalToItemStackRecipe;
import com.jerry.mekmm.api.recipes.cache.ReplicatorCachedRecipe;
import com.jerry.mekmm.client.recipe_viewer.MMRecipeViewerRecipeType;
import com.jerry.mekmm.common.config.MoreMachineConfig;
import com.jerry.mekmm.common.recipe.impl.ReplicatorIRecipeSingle;
import com.jerry.mekmm.common.registries.MoreMachineChemicals;
import com.jerry.mekmm.common.tile.factory.TileEntityMoreMachineItemToItemFactory;
import com.jerry.mekmm.common.util.ValidatorUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.Mekanism;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.IDoubleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IHasDumpButton;
import mekanism.common.tile.interfaces.ISideConfiguration;
import mekanism.common.upgrade.AdvancedMachineUpgradeData;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityReplicatingFactory
extends TileEntityMoreMachineItemToItemFactory<MMBasicItemStackChemicalToItemStackRecipe>
implements IHasDumpButton,
IDoubleRecipeLookupHandler.ItemChemicalRecipeLookupHandler<MMBasicItemStackChemicalToItemStackRecipe> {
    protected static final DoubleInputRecipeCache.CheckRecipeType<ItemStack, ChemicalStack, MMBasicItemStackChemicalToItemStackRecipe, ItemStack> OUTPUT_CHECK = (recipe, input, extra, output) -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput((ItemStack)input, (ChemicalStack)extra), (ItemStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_SECONDARY_INPUT);
    public static final long MAX_GAS = 10000L;
    public static HashMap<String, Integer> customRecipeMap = ValidatorUtils.getRecipeFromConfig((List)MoreMachineConfig.general.itemReplicatorRecipe.get());
    private final ILongInputHandler<ChemicalStack> chemicalInputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getChemical", "getChemicalCapacity", "getChemicalNeeded", "getChemicalFilledPercentage"}, docPlaceholder="chemical tank")
    public IChemicalTank chemicalTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getChemicalItem"}, docPlaceholder="chemical item slot")
    ChemicalInventorySlot chemicalSlot;

    public TileEntityReplicatingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.configComponent.setupInputConfig(TransmissionType.CHEMICAL, (Object)this.chemicalTank);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
        this.chemicalInputHandler = InputHelper.getConstantInputHandler((IChemicalTank)this.chemicalTank);
    }

    @Nullable
    public ChemicalInventorySlot getExtraSlot() {
        return this.chemicalSlot;
    }

    @Nullable
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener) {
        ChemicalTankHelper builder = ChemicalTankHelper.forSideWithConfig((ISideConfiguration)this);
        this.chemicalTank = BasicChemicalTank.inputModern((long)(10000L * (long)this.tier.processes), TileEntityReplicatingFactory::isValidChemicalInput, (IContentsListener)this.markAllMonitorsChanged(listener));
        builder.addTank(this.chemicalTank);
        return builder.build();
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        super.addSlots(builder, listener, updateSortingListener);
        this.chemicalSlot = ChemicalInventorySlot.fillOrConvert((IChemicalTank)this.chemicalTank, () -> ((TileEntityReplicatingFactory)this).getLevel(), (IContentsListener)listener, (int)7, (int)57);
        builder.addSlot((IInventorySlot)this.chemicalSlot);
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<MMBasicItemStackChemicalToItemStackRecipe> cached, @NotNull ItemStack stack) {
        return cached != null && TileEntityReplicatingFactory.isValidChemicalInput(this.chemicalTank.getStack());
    }

    @Override
    @Nullable
    protected MMBasicItemStackChemicalToItemStackRecipe findRecipe(int process, @NotNull ItemStack fallbackInput, @NotNull IInventorySlot outputSlot, @Nullable IInventorySlot secondaryOutputSlot) {
        return null;
    }

    @Override
    protected void handleSecondaryFuel() {
        this.chemicalSlot.fillTankOrConvert();
    }

    @Override
    protected int getNeededInput(MMBasicItemStackChemicalToItemStackRecipe recipe, ItemStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getItemInput().getNeededAmount(inputStack));
    }

    @Override
    public boolean isItemValidForSlot(@NotNull ItemStack stack) {
        return true;
    }

    public static boolean isValidChemicalInput(ChemicalStack stack) {
        return stack.is(MoreMachineChemicals.UU_MATTER);
    }

    @Override
    public boolean isValidInputItem(ItemStack stack) {
        Item item = stack.getItem();
        if (customRecipeMap != null) {
            return customRecipeMap.containsKey(Objects.requireNonNull(RegistryUtils.getName((Holder)item.builtInRegistryHolder())).toString());
        }
        return false;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, MMBasicItemStackChemicalToItemStackRecipe, InputRecipeCache.ItemChemical<MMBasicItemStackChemicalToItemStackRecipe>> getRecipeType() {
        return null;
    }

    @Nullable
    public MMBasicItemStackChemicalToItemStackRecipe getRecipe(int cacheIndex) {
        return TileEntityReplicatingFactory.getRecipe((ItemStack)this.inputHandlers[cacheIndex].getInput(), (ChemicalStack)this.chemicalInputHandler.getInput());
    }

    @NotNull
    public CachedRecipe<MMBasicItemStackChemicalToItemStackRecipe> createNewCachedRecipe(@NotNull MMBasicItemStackChemicalToItemStackRecipe recipe, int cacheIndex) {
        return ReplicatorCachedRecipe.createItemReplicator(recipe, this.recheckAllRecipeErrors[cacheIndex], (IInputHandler<ItemStack>)this.inputHandlers[cacheIndex], this.chemicalInputHandler, (IOutputHandler<ItemStack>)this.outputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityReplicatingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((MachineEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityReplicatingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    @Nullable
    public IRecipeViewerRecipeType<MMBasicItemStackChemicalToItemStackRecipe> recipeViewerType() {
        return MMRecipeViewerRecipeType.REPLICATOR;
    }

    public static MMBasicItemStackChemicalToItemStackRecipe getRecipe(ItemStack itemStack, ChemicalStack chemicalStack) {
        if (chemicalStack.isEmpty() || itemStack.isEmpty()) {
            return null;
        }
        if (customRecipeMap != null) {
            Item item = itemStack.getItem();
            int amount = customRecipeMap.getOrDefault(RegistryUtils.getName((Holder)itemStack.getItemHolder()).toString(), 0);
            if (amount == 0) {
                return null;
            }
            return new ReplicatorIRecipeSingle(IngredientCreatorAccess.item().from(item, 1), IngredientCreatorAccess.chemicalStack().fromHolder(MoreMachineChemicals.UU_MATTER, amount), new ItemStack((ItemLike)item, 1));
        }
        return null;
    }

    @Override
    public boolean hasSecondaryResourceBar() {
        return true;
    }

    @Override
    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof AdvancedMachineUpgradeData) {
            AdvancedMachineUpgradeData data = (AdvancedMachineUpgradeData)upgradeData;
            super.parseUpgradeData(provider, upgradeData);
            this.chemicalTank.deserializeNBT(provider, data.stored.serializeNBT(provider));
            this.chemicalSlot.deserializeNBT(provider, data.chemicalSlot.serializeNBT(provider));
        } else {
            Mekanism.logger.warn("Unhandled upgrade data.", new Throwable());
        }
    }

    @Nullable
    public AdvancedMachineUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new AdvancedMachineUpgradeData(provider, this.redstone, this.getControlType(), this.getEnergyContainer(), this.progress, null, this.chemicalTank, this.chemicalSlot, this.energySlot, this.inputSlots, this.outputSlots, this.isSorting(), this.getComponents());
    }

    public void dump() {
        this.chemicalTank.setEmpty();
    }

    @ComputerMethod(requiresPublicSecurity=true, methodDescription="Empty the contents of the chemical tank into the environment")
    void dumpChemical() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dump();
    }

    @Generated
    public IChemicalTank getChemicalTank() {
        return this.chemicalTank;
    }
}

