/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.util.ItemStackUtil;
import com.jerry.mekmm.api.recipes.PlantingRecipe;
import com.jerry.mekmm.api.recipes.basic.BasicPlantingRecipe;
import com.jerry.mekmm.common.recipe.MoreMachineRecipeType;
import java.util.List;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleItemChemicalRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.util.text.TextUtils;
import net.minecraft.world.item.ItemStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekmm.recipe.manager.Planting")
public class PlantingRecipeManager
extends MekanismRecipeManager<SingleItemChemicalRecipeInput, PlantingRecipe> {
    public static final PlantingRecipeManager INSTANCE = new PlantingRecipeManager();

    protected PlantingRecipeManager() {
        super(MoreMachineRecipeType.PLANTING_STATION);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack mainOutput, boolean perTickUsage) {
        this.addRecipe(name, this.makeRecipe(itemInput, chemicalInput, mainOutput, perTickUsage));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack secondaryOutput, double secondaryChance, boolean perTickUsage) {
        this.addRecipe(name, this.makeRecipe(itemInput, chemicalInput, secondaryOutput, secondaryChance, perTickUsage));
    }

    @ZenCodeType.Method
    public void addRecipe(String name, IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack mainOutput, IItemStack secondaryOutput, double secondaryChance, boolean perTickUsage) {
        this.addRecipe(name, this.makeRecipe(itemInput, chemicalInput, mainOutput, secondaryOutput, secondaryChance, perTickUsage));
    }

    public final PlantingRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack mainOutput, boolean perTickUsage) {
        return new BasicPlantingRecipe(CrTUtils.fromCrT((IIngredientWithAmount)itemInput), chemicalInput, this.getAndValidateNotEmpty(mainOutput), ItemStack.EMPTY, 0.0, perTickUsage);
    }

    public final PlantingRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack secondaryOutput, double secondaryChance, boolean perTickUsage) {
        return new BasicPlantingRecipe(CrTUtils.fromCrT((IIngredientWithAmount)itemInput), chemicalInput, ItemStack.EMPTY, this.getAndValidateNotEmpty(secondaryOutput), this.getAndValidateSecondaryChance(secondaryChance), perTickUsage);
    }

    public final PlantingRecipe makeRecipe(IIngredientWithAmount itemInput, ChemicalStackIngredient chemicalInput, IItemStack mainOutput, IItemStack secondaryOutput, double secondaryChance, boolean perTickUsage) {
        return new BasicPlantingRecipe(CrTUtils.fromCrT((IIngredientWithAmount)itemInput), chemicalInput, this.getAndValidateNotEmpty(mainOutput), this.getAndValidateNotEmpty(secondaryOutput), this.getAndValidateSecondaryChance(secondaryChance), perTickUsage);
    }

    private double getAndValidateSecondaryChance(double secondaryChance) {
        if (secondaryChance <= 0.0 || secondaryChance > 1.0) {
            throw new IllegalArgumentException("This planting recipe requires a secondary output chance greater than zero and at most one.");
        }
        return secondaryChance;
    }

    protected String describeOutputs(PlantingRecipe recipe) {
        StringBuilder builder = new StringBuilder();
        List<ItemStack> mainOutputs = recipe.getMainOutputDefinition();
        if (!mainOutputs.isEmpty()) {
            builder.append("main: ").append(CrTUtils.describeOutputs(mainOutputs, ItemStackUtil::getCommandString));
        }
        if (recipe.getSecondaryChance() > 0.0) {
            if (!mainOutputs.isEmpty()) {
                builder.append("; ");
            }
            if (recipe.getSecondaryChance() == 1.0) {
                builder.append("secondary: ");
            } else {
                builder.append("secondary with chance ").append(TextUtils.getPercent((double)recipe.getSecondaryChance())).append(": ");
            }
            builder.append(CrTUtils.describeOutputs(recipe.getSecondaryOutputDefinition(), ItemStackUtil::getCommandString));
        }
        return builder.toString();
    }
}

