/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.integration.crafttweaker.recipe.handler;

import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.component.DecomposedRecipeBuilder;
import com.blamejared.crafttweaker.api.recipe.component.IDecomposedRecipe;
import com.blamejared.crafttweaker.api.recipe.component.IRecipeComponent;
import com.blamejared.crafttweaker.api.recipe.handler.IRecipeHandler;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import com.jerry.mekmm.api.recipes.PlantingRecipe;
import com.jerry.mekmm.common.integration.crafttweaker.recipe.manager.PlantingRecipeManager;
import java.util.List;
import java.util.Optional;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.common.integration.crafttweaker.CrTRecipeComponents;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.recipe.handler.MekanismRecipeHandler;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;

@IRecipeHandler.For(value=PlantingRecipe.class)
public class PlantingRecipeHandler
extends MekanismRecipeHandler<PlantingRecipe> {
    public String dumpToCommandString(IRecipeManager<? super PlantingRecipe> manager, RegistryAccess registryAccess, RecipeHolder<PlantingRecipe> recipeHolder) {
        PlantingRecipe recipe = (PlantingRecipe)recipeHolder.value();
        boolean hasSecondary = recipe.getSecondaryChance() > 0.0;
        List<ItemStack> mainOutputDefinition = recipe.getMainOutputDefinition();
        return this.buildCommandString(manager, recipeHolder, new Object[]{recipe.getItemInput(), recipe.getChemicalInput(), mainOutputDefinition.isEmpty() ? SKIP_OPTIONAL_PARAM : mainOutputDefinition, hasSecondary ? recipe.getSecondaryOutputDefinition() : SKIP_OPTIONAL_PARAM, hasSecondary ? Double.valueOf(recipe.getSecondaryChance()) : SKIP_OPTIONAL_PARAM, recipe.perTickUsage()});
    }

    public <U extends Recipe<?>> boolean doesConflict(IRecipeManager<? super PlantingRecipe> manager, PlantingRecipe recipe, U o) {
        if (o instanceof PlantingRecipe) {
            PlantingRecipe other = (PlantingRecipe)o;
            return this.ingredientConflicts((InputIngredient)recipe.getItemInput(), (InputIngredient)other.getItemInput()) && this.chemicalIngredientConflicts(recipe.getChemicalInput(), other.getChemicalInput());
        }
        return false;
    }

    public Optional<IDecomposedRecipe> decompose(IRecipeManager<? super PlantingRecipe> manager, RegistryAccess registryAccess, PlantingRecipe recipe) {
        List<ItemStack> mainOutputDefinition = recipe.getMainOutputDefinition();
        if (mainOutputDefinition.size() > 1) {
            return Optional.empty();
        }
        List<ItemStack> secondaryOutputDefinition = recipe.getSecondaryOutputDefinition();
        if (secondaryOutputDefinition.size() > 1 || secondaryOutputDefinition.isEmpty() == recipe.getSecondaryChance() > 0.0) {
            return Optional.empty();
        }
        if (mainOutputDefinition.isEmpty() && secondaryOutputDefinition.isEmpty()) {
            return Optional.empty();
        }
        DecomposedRecipeBuilder builder = IDecomposedRecipe.builder().with(CrTRecipeComponents.ITEM.input(), (Object)CrTUtils.toCrT((ItemStackIngredient)recipe.getItemInput()));
        builder.with(CrTRecipeComponents.CHEMICAL.input(), (Object)recipe.getChemicalInput());
        if (mainOutputDefinition.isEmpty()) {
            builder.with(CrTRecipeComponents.ITEM.output(), CrTUtils.convertItems(secondaryOutputDefinition)).with(CrTRecipeComponents.CHANCE, (Object)recipe.getSecondaryChance());
        } else if (secondaryOutputDefinition.isEmpty()) {
            builder.with(CrTRecipeComponents.ITEM.output(), CrTUtils.convertItems(mainOutputDefinition));
        } else {
            builder.with(CrTRecipeComponents.ITEM.output(), CrTUtils.convertItems(List.of(mainOutputDefinition.getFirst(), secondaryOutputDefinition.getFirst()))).with(CrTRecipeComponents.CHANCE, (Object)recipe.getSecondaryChance());
        }
        return Optional.of(builder.build());
    }

    public Optional<PlantingRecipe> recompose(IRecipeManager<? super PlantingRecipe> m, RegistryAccess registryAccess, IDecomposedRecipe recipe) {
        if (m instanceof PlantingRecipeManager) {
            IItemStack secondaryOutput;
            PlantingRecipeManager manager = (PlantingRecipeManager)m;
            IIngredientWithAmount itemInput = (IIngredientWithAmount)recipe.getOrThrowSingle(CrTRecipeComponents.ITEM.input());
            ChemicalStackIngredient chemicalInput = (ChemicalStackIngredient)recipe.getOrThrowSingle(CrTRecipeComponents.CHEMICAL.input());
            List outputs = recipe.get(CrTRecipeComponents.ITEM.output());
            boolean per_tick_usage = (Boolean)recipe.getOrThrowSingle(CrTRecipeComponents.PER_TICK_USAGE);
            if (outputs == null || outputs.isEmpty() || outputs.size() > 2) {
                throw new IllegalArgumentException("Incorrect number of outputs specified. Must be either one or two outputs, and have a secondary chance if two.");
            }
            double chance = CrTUtils.getSingleIfPresent((IDecomposedRecipe)recipe, (IRecipeComponent)CrTRecipeComponents.CHANCE).orElse(0.0);
            if (chance == 0.0 && outputs.size() == 2) {
                throw new IllegalArgumentException("No chance of specified secondary output.");
            }
            IItemStack output = (IItemStack)outputs.get(0);
            if (outputs.size() == 1) {
                if (chance > 1.0 && chance < 2.0) {
                    chance -= 1.0;
                    secondaryOutput = output.copy();
                } else {
                    secondaryOutput = IItemStack.empty();
                }
            } else {
                secondaryOutput = (IItemStack)outputs.get(1);
            }
            if (secondaryOutput.isEmpty()) {
                if (chance == 0.0 || chance == 1.0) {
                    return Optional.of(manager.makeRecipe(itemInput, chemicalInput, output, per_tick_usage));
                }
                return Optional.of(manager.makeRecipe(itemInput, chemicalInput, output, chance, per_tick_usage));
            }
            return Optional.of(manager.makeRecipe(itemInput, chemicalInput, output, secondaryOutput, chance, per_tick_usage));
        }
        return Optional.empty();
    }
}

