/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.common.config;

import com.jerry.meklm.api.tier.ILargeChemicalTankTier;
import com.jerry.meklm.common.tier.MaxChemicalTankTier;
import com.jerry.meklm.common.tier.MidChemicalTankTier;
import com.jerry.mekmm.common.config.MoreMachineConfigTranslations;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import java.util.Locale;
import mekanism.api.tier.ITier;
import mekanism.common.config.BaseMekanismConfig;
import mekanism.common.config.IMekanismConfig;
import mekanism.common.config.MekanismConfigTranslations;
import mekanism.common.config.value.CachedLongValue;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MoreMachineTierConfig
extends BaseMekanismConfig {
    private final ModConfigSpec configSpec;

    MoreMachineTierConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        this.addMaxChemicalTankCategory(builder);
        this.addMidChemicalTankCategory(builder);
        this.configSpec = builder.build();
    }

    private void addMaxChemicalTankCategory(ModConfigSpec.Builder builder) {
        MoreMachineConfigTranslations.TIER_MID_CHEMICAL_TANK.applyToBuilder(builder).push("max_chemical_tanks");
        for (MaxChemicalTankTier tier : MoreMachineEnumUtils.MAX_CHEMICAL_TANK_TIERS) {
            MekanismConfigTranslations.TierTranslations translations = MoreMachineTierConfig.create(tier);
            String tierName = tier.getBaseTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedLongValue storageReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName + "Capacity", tier.getBaseStorage(), 1L, Long.MAX_VALUE));
            CachedLongValue outputReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.second().applyToBuilder(builder).defineInRange(tierName + "Output", tier.getBaseOutput(), 1L, Long.MAX_VALUE));
            tier.setConfigReference(storageReference, outputReference);
        }
        builder.pop();
    }

    private void addMidChemicalTankCategory(ModConfigSpec.Builder builder) {
        MoreMachineConfigTranslations.TIER_MAX_CHEMICAL_TANK.applyToBuilder(builder).push("mid_chemical_tanks");
        for (MidChemicalTankTier tier : MoreMachineEnumUtils.MID_CHEMICAL_TANK_TIERS) {
            MekanismConfigTranslations.TierTranslations translations = MoreMachineTierConfig.create(tier);
            String tierName = tier.getBaseTier().getSimpleName().toLowerCase(Locale.ROOT);
            CachedLongValue storageReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.first().applyToBuilder(builder).defineInRange(tierName + "Capacity", tier.getBaseStorage(), 1L, Long.MAX_VALUE));
            CachedLongValue outputReference = CachedLongValue.wrap((IMekanismConfig)this, (ModConfigSpec.ConfigValue)translations.second().applyToBuilder(builder).defineInRange(tierName + "Output", tier.getBaseOutput(), 1L, Long.MAX_VALUE));
            tier.setConfigReference(storageReference, outputReference);
        }
        builder.pop();
    }

    public static MekanismConfigTranslations.TierTranslations create(ILargeChemicalTankTier tier) {
        return MekanismConfigTranslations.TierTranslations.create((ITier)tier, (String)(tier.getType().toLowerCase(Locale.ROOT) + "_chemical_tank"), name -> "Storage size of " + name + " " + tier.getType().toLowerCase(Locale.ROOT) + " chemical tanks in mB.", name -> "Output rate of " + name + " " + tier.getType().toLowerCase(Locale.ROOT) + " chemical tanks in mB.");
    }

    public String getFileName() {
        return "tiers";
    }

    public String getTranslation() {
        return "Tier Config";
    }

    public ModConfigSpec getConfigSpec() {
        return this.configSpec;
    }

    public ModConfig.Type getConfigType() {
        return ModConfig.Type.SERVER;
    }
}

