/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.recipe_viewer.jei.machine;

import com.jerry.mekmm.api.recipes.PlantingRecipe;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiEmptyBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.jei.HolderRecipeCategory;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.placement.HorizontalAlignment;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.ITextWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.crafting.RecipeHolder;

@NothingNullByDefault
public class PlantingRecipeCategory
extends HolderRecipeCategory<PlantingRecipe> {
    private final GuiBar<?> chemicalInput;
    private final GuiSlot input = this.addSlot(SlotType.INPUT, 56, 17);
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 56, 53);
    private final GuiSlot output;

    public PlantingRecipeCategory(IGuiHelper helper, IRecipeViewerRecipeType<PlantingRecipe> recipeType) {
        super(helper, recipeType);
        this.addSlot(SlotType.POWER, 31, 35).with(SlotOverlay.POWER);
        this.output = this.addSlot(SlotType.OUTPUT_WIDE, 112, 31);
        this.addElement((GuiElement)new GuiVerticalPowerBar((IGuiWrapper)this, RecipeViewerUtils.FULL_BAR, 164, 15));
        this.chemicalInput = (GuiBar)this.addElement((GuiElement)new GuiEmptyBar((IGuiWrapper)this, 60, 36, 6, 12));
        this.addSimpleProgress(ProgressType.BAR, 78, 38);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<PlantingRecipe> recipeHolder, IFocusGroup focuses) {
        super.createRecipeExtras(builder, recipeHolder, focuses);
        double secondaryChance = ((PlantingRecipe)recipeHolder.value()).getSecondaryChance();
        if (secondaryChance > 0.0) {
            Component component = TextUtils.getPercent((double)secondaryChance);
            int n = this.output.getWidth() - 2;
            Objects.requireNonNull(this.font());
            ((ITextWidget)builder.addText((FormattedText)component, n, 9).setPosition(this.getGuiLeft() + this.output.getRelativeX() + 1, this.getGuiTop() + this.output.getRelativeBottom() + 1)).setTextAlignment(HorizontalAlignment.RIGHT).setColor(this.titleTextColor());
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<PlantingRecipe> recipeHolder, IFocusGroup focusGroup) {
        PlantingRecipe recipe = (PlantingRecipe)recipeHolder.value();
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getItemInput().getRepresentations());
        List<ChemicalStack> scaledChemicals = recipe.getChemicalInput().getRepresentations();
        if (recipe.perTickUsage()) {
            scaledChemicals = scaledChemicals.stream().map(chemical -> chemical.copyWithAmount(chemical.getAmount() * 200L)).toList();
        }
        this.initChemical(builder, RecipeIngredientRole.INPUT, (GuiElement)this.chemicalInput, scaledChemicals);
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output.getX() + 4, this.output.getY() + 4, recipe.getMainOutputDefinition());
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output.getX() + 20, this.output.getY() + 4, recipe.getSecondaryOutputDefinition());
        this.initItem(builder, RecipeIngredientRole.CATALYST, this.extra, RecipeViewerUtils.getStacksFor((ChemicalStackIngredient)recipe.getChemicalInput(), (boolean)true));
    }
}

