/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.client.gui.element.button;

import com.jerry.mekmm.common.attachments.component.ConnectionConfig;
import com.jerry.mekmm.common.attachments.component.WirelessConnectionManager;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.ObjIntConsumer;
import mekanism.api.SupportsColorMap;
import mekanism.api.text.EnumColor;
import mekanism.client.gui.GuiUtils;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.slot.GuiSequencedSlotDisplay;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectListButton
extends MekanismButton {
    private static final ResourceLocation TEXTURE = MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI_BUTTON, (String)"lists_holder.png");
    protected static final int TEXTURE_WIDTH = 131;
    protected static final int TEXTURE_HEIGHT = 58;
    private final GuiSequencedSlotDisplay slotDisplay;
    private final GuiSlot slot;
    private final IntSupplier connectIndex;
    private final WirelessConnectionManager connectManager;
    private final ObjIntConsumer<ConnectionConfig> onPress;
    private final int index;
    private ConnectionConfig prevConnection;
    private final Level level;

    private static ConnectionConfig getConnection(WirelessConnectionManager connectManager, int index) {
        if (index >= 0 && index < connectManager.getConnectionCount()) {
            return connectManager.getConnections().get(index);
        }
        return null;
    }

    public ConnectListButton(IGuiWrapper gui, int x, int y, int index, IntSupplier connectIndex, WirelessConnectionManager connectManager, ObjIntConsumer<ConnectionConfig> onPress, Function<ConnectionConfig, List<ItemStack>> renderStackSupplier, Level level) {
        super(gui, x, y, 131, 29, CommonComponents.EMPTY, (element, mouseX, mouseY) -> {
            ConnectListButton button = (ConnectListButton)element;
            int actualIndex = button.connectIndex.getAsInt() + button.index;
            button.onPress.accept(ConnectListButton.getConnection(button.connectManager, actualIndex), actualIndex);
            return true;
        });
        this.index = index;
        this.connectIndex = connectIndex;
        this.connectManager = connectManager;
        this.onPress = onPress;
        this.level = level;
        this.slot = (GuiSlot)this.addChild((GuiElement)new GuiSlot(SlotType.NORMAL, gui, this.relativeX + 2, this.relativeY + 2));
        this.slotDisplay = (GuiSequencedSlotDisplay)this.addChild((GuiElement)new GuiSequencedSlotDisplay(gui, this.relativeX + 3, this.relativeY + 3, () -> (List)renderStackSupplier.apply(this.getConnection())));
        this.setButtonBackground(GuiElement.ButtonBackground.NONE);
    }

    protected void setVisibility(boolean visible) {
        this.visible = visible;
        this.slot.visible = visible;
        this.slotDisplay.visible = visible;
    }

    protected int getActualIndex() {
        return this.connectIndex.getAsInt() + this.index;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.setVisibility(this.getConnection() != null);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Nullable
    protected ConnectionConfig getConnection() {
        return ConnectListButton.getConnection(this.connectManager, this.getActualIndex());
    }

    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.drawBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(TEXTURE, this.getButtonX(), this.getButtonY(), this.getButtonWidth(), this.getButtonHeight(), 0.0f, this.isMouseOverCheckWindows(mouseX, mouseY) ? 0.0f : 29.0f, 131, 29, 131, 58);
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        ConnectionConfig connection = this.getConnection();
        if (connection != this.prevConnection) {
            this.slotDisplay.updateStackList();
            this.prevConnection = connection;
        }
        EnumColor color = switch (connection.type()) {
            default -> throw new MatchException(null, null);
            case TransmissionType.ENERGY -> EnumColor.BRIGHT_GREEN;
            case TransmissionType.FLUID -> EnumColor.AQUA;
            case TransmissionType.CHEMICAL -> EnumColor.YELLOW;
            case TransmissionType.ITEM -> EnumColor.GRAY;
            case TransmissionType.HEAT -> EnumColor.ORANGE;
        };
        GuiUtils.fill((GuiGraphics)guiGraphics, (int)this.getButtonX(), (int)this.getButtonY(), (int)this.getButtonWidth(), (int)this.getButtonHeight(), (int)MekanismRenderer.getColorARGB((SupportsColorMap)color, (float)0.3f));
        Component connectionDescriptor = this.level.getBlockState(connection.pos()).getBlock().asItem().getDefaultInstance().getHoverName();
        this.drawScrollingString(guiGraphics, connectionDescriptor, 19, 3, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), 227, 3, false);
    }
}

