/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.outputs;

import com.jerry.mekmm.api.recipes.RecyclerRecipe;
import java.util.Objects;
import mekanism.api.Action;
import mekanism.api.AutomationType;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.world.item.ItemStack;

@NothingNullByDefault
public class MoreMachineOutputHelper {
    private MoreMachineOutputHelper() {
    }

    public static IOutputHandler<RecyclerRecipe.ChanceOutput> getOutputHandler(final IInventorySlot chanceSlot, final CachedRecipe.OperationTracker.RecipeError chanceSlotNotEnoughSpaceError) {
        Objects.requireNonNull(chanceSlot, "Chance slot cannot be null.");
        Objects.requireNonNull(chanceSlotNotEnoughSpaceError, "Chance slot not enough space error cannot be null.");
        return new IOutputHandler<RecyclerRecipe.ChanceOutput>(){

            public void handleOutput(RecyclerRecipe.ChanceOutput toOutput, int operations) {
                ItemStack chanceOutput = toOutput.getChanceOutput();
                for (int i = 0; i < operations; ++i) {
                    MoreMachineOutputHelper.handleOutput(chanceSlot, chanceOutput, operations);
                    if (i >= operations - 1) continue;
                    chanceOutput = toOutput.nextChanceOutput();
                }
            }

            public void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, RecyclerRecipe.ChanceOutput toOutput) {
                MoreMachineOutputHelper.calculateOperationsCanSupport(tracker, chanceSlotNotEnoughSpaceError, chanceSlot, toOutput.getMaxChanceOutput());
            }
        };
    }

    private static void handleOutput(IInventorySlot inventorySlot, ItemStack toOutput, int operations) {
        if (operations == 0 || toOutput.isEmpty()) {
            return;
        }
        ItemStack output = toOutput.copy();
        if (operations > 1) {
            output.setCount(output.getCount() * operations);
        }
        inventorySlot.insertItem(output, Action.EXECUTE, AutomationType.INTERNAL);
    }

    private static void calculateOperationsCanSupport(CachedRecipe.OperationTracker tracker, CachedRecipe.OperationTracker.RecipeError notEnoughSpace, IInventorySlot slot, ItemStack toOutput) {
        if (!toOutput.isEmpty()) {
            ItemStack output = toOutput.copyWithCount(toOutput.getMaxStackSize());
            ItemStack remainder = slot.insertItem(output, Action.SIMULATE, AutomationType.INTERNAL);
            int amountUsed = output.getCount() - remainder.getCount();
            int operations = amountUsed / toOutput.getCount();
            tracker.updateOperations(operations);
            if (operations == 0) {
                if (amountUsed == 0 && slot.getLimit(slot.getStack()) - slot.getCount() > 0) {
                    tracker.addError(CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
                } else {
                    tracker.addError(notEnoughSpace);
                }
            }
        }
    }
}

