/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.basic;

import com.jerry.mekmm.api.recipes.MoreMachineRecipeSerializers;
import com.jerry.mekmm.api.recipes.StamperRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class BasicStamperRecipe
extends StamperRecipe {
    protected final ItemStackIngredient input;
    protected final ItemStackIngredient mold;
    protected final ItemStack output;

    public BasicStamperRecipe(ItemStackIngredient input, ItemStackIngredient mold, ItemStack output) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        this.mold = Objects.requireNonNull(mold, "Mold cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    public boolean test(ItemStack input, ItemStack extra) {
        return this.input.test(input) && this.mold.test(extra);
    }

    @Override
    public ItemStackIngredient getInput() {
        return this.input;
    }

    @Override
    public ItemStackIngredient getMold() {
        return this.mold;
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(@NotNull ItemStack input, @NotNull ItemStack extra) {
        return this.output.copy();
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @Override
    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    public ItemStack getOutputRaw() {
        return this.output;
    }

    public RecipeSerializer<BasicStamperRecipe> getSerializer() {
        return (RecipeSerializer)MoreMachineRecipeSerializers.STAMPING.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicStamperRecipe other = (BasicStamperRecipe)o;
        return this.input.equals((Object)other.input) && this.mold.equals((Object)other.mold) && ItemStack.matches((ItemStack)this.output, (ItemStack)other.output);
    }

    public int hashCode() {
        int hash = Objects.hash(this.input, this.mold);
        hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.output);
        hash = 31 * hash + this.output.getCount();
        return hash;
    }
}

