/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekmm.api.recipes.basic;

import com.jerry.mekmm.api.recipes.MoreMachineRecipeSerializers;
import com.jerry.mekmm.api.recipes.PlantingRecipe;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class BasicPlantingRecipe
extends PlantingRecipe {
    public final ItemStackIngredient itemInput;
    public final ChemicalStackIngredient chemicalInput;
    public final ItemStack mainOutput;
    public final ItemStack secondaryOutput;
    protected final double secondaryChance;
    private final boolean perTickUsage;

    public BasicPlantingRecipe(ItemStackIngredient itemInput, ChemicalStackIngredient chemicalInput, ItemStack mainOutput, ItemStack secondaryOutput, double secondaryChance, boolean perTickUsage) {
        this.itemInput = Objects.requireNonNull(itemInput, "Input cannot be null.");
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(mainOutput, "Main output cannot be null.");
        Objects.requireNonNull(secondaryOutput, "Secondary output cannot be null.");
        if (mainOutput.isEmpty() && secondaryOutput.isEmpty()) {
            throw new IllegalArgumentException("At least one output must not be empty.");
        }
        if (secondaryChance < 0.0 || secondaryChance > 1.0) {
            throw new IllegalArgumentException("Secondary output chance must be at least zero and at most one.");
        }
        if (mainOutput.isEmpty()) {
            if (secondaryChance == 0.0 || secondaryChance == 1.0) {
                throw new IllegalArgumentException("Secondary output must have a chance greater than zero and less than one.");
            }
        } else if (secondaryOutput.isEmpty() && secondaryChance != 0.0) {
            throw new IllegalArgumentException("If there is no secondary output, the chance of getting the secondary output should be zero.");
        }
        this.mainOutput = mainOutput.copy();
        this.secondaryOutput = secondaryOutput.copy();
        this.secondaryChance = secondaryChance;
        this.perTickUsage = perTickUsage;
    }

    @Override
    public boolean test(@NotNull ItemStack itemStack, ChemicalStack chemicalStack) {
        return this.itemInput.test(itemStack) && this.chemicalInput.test(chemicalStack);
    }

    @Override
    public boolean perTickUsage() {
        return this.perTickUsage;
    }

    @Override
    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    @Override
    public ChemicalStackIngredient getChemicalInput() {
        return this.chemicalInput;
    }

    @Override
    public List<ItemStack> getMainOutputDefinition() {
        return this.mainOutput.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.mainOutput);
    }

    @Override
    public List<ItemStack> getSecondaryOutputDefinition() {
        return this.secondaryOutput.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.secondaryOutput);
    }

    @Override
    public double getSecondaryChance() {
        return this.secondaryChance;
    }

    public Optional<ItemStack> getMainOutputRaw() {
        return this.mainOutput.isEmpty() ? Optional.empty() : Optional.of(this.mainOutput);
    }

    public Optional<ItemStack> getSecondaryOutputRaw() {
        return this.secondaryOutput.isEmpty() ? Optional.empty() : Optional.of(this.secondaryOutput);
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public SawmillRecipe.ChanceOutput getOutput(ItemStack solid, ChemicalStack chemical) {
        return new BasicChanceOutput(this.secondaryChance > 0.0 ? RANDOM.nextDouble() : 0.0);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)MoreMachineRecipeSerializers.PLANTING.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicPlantingRecipe other = (BasicPlantingRecipe)o;
        return this.secondaryChance == other.secondaryChance && this.itemInput.equals((Object)other.itemInput) && this.chemicalInput.equals((Object)other.chemicalInput) && ItemStack.matches((ItemStack)this.mainOutput, (ItemStack)other.mainOutput) && ItemStack.matches((ItemStack)this.secondaryOutput, (ItemStack)other.secondaryOutput);
    }

    public int hashCode() {
        int hash = 31 * this.itemInput.hashCode() + this.chemicalInput.hashCode();
        hash = 31 * hash + Double.hashCode(this.secondaryChance);
        hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.mainOutput);
        hash = 31 * hash + this.mainOutput.getCount();
        if (!this.secondaryOutput.isEmpty()) {
            hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.secondaryOutput);
            hash = 31 * hash + this.secondaryOutput.getCount();
        }
        return hash;
    }

    public class BasicChanceOutput
    implements SawmillRecipe.ChanceOutput {
        protected final double rand;

        protected BasicChanceOutput(double rand) {
            this.rand = rand;
        }

        public ItemStack getMainOutput() {
            return BasicPlantingRecipe.this.mainOutput.copy();
        }

        public ItemStack getMaxSecondaryOutput() {
            return BasicPlantingRecipe.this.secondaryChance > 0.0 ? BasicPlantingRecipe.this.secondaryOutput.copy() : ItemStack.EMPTY;
        }

        public ItemStack getSecondaryOutput() {
            if (this.rand <= BasicPlantingRecipe.this.secondaryChance) {
                return BasicPlantingRecipe.this.secondaryOutput.copy();
            }
            return ItemStack.EMPTY;
        }

        public ItemStack nextSecondaryOutput() {
            double rand;
            if (BasicPlantingRecipe.this.secondaryChance > 0.0 && (rand = RANDOM.nextDouble()) <= BasicPlantingRecipe.this.secondaryChance) {
                return BasicPlantingRecipe.this.secondaryOutput.copy();
            }
            return ItemStack.EMPTY;
        }
    }
}

