/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.tile.machine;

import com.jerry.meklm.common.capabilities.holder.chemical.CanAdjustChemicalTankHelper;
import com.jerry.meklm.common.capabilities.holder.fluid.CanAdjustFluidTankHelper;
import com.jerry.meklm.common.registries.LargeMachineBlocks;
import com.jerry.meklm.common.tile.INeedConfig;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import lombok.Generated;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.functions.LongObjectToLongFunction;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ElectrolysisRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.recipes.vanilla_input.SingleFluidRecipeInput;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.FixedUsageEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.registries.MekanismDataComponents;
import mekanism.common.tile.TileEntityChemicalTank;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.interfaces.IHasGasMode;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeElectrolyticSeparator
extends TileEntityRecipeMachine<ElectrolysisRecipe>
implements IBoundingBlock,
IHasGasMode,
ISingleRecipeLookupHandler.FluidRecipeLookupHandler<ElectrolysisRecipe>,
INeedConfig {
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_LEFT_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final CachedRecipe.OperationTracker.RecipeError NOT_ENOUGH_SPACE_RIGHT_OUTPUT_ERROR = CachedRecipe.OperationTracker.RecipeError.create();
    public static final long MAX_GAS = 24000000L;
    public static final int MAX_FLUID = 24000000;
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, NOT_ENOUGH_SPACE_LEFT_OUTPUT_ERROR, NOT_ENOUGH_SPACE_RIGHT_OUTPUT_ERROR, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final int BASE_DUMP_RATE = 8;
    private static final LongObjectToLongFunction<TileEntityLargeElectrolyticSeparator> BASE_ENERGY_CALCULATOR = (base, tile) -> base * tile.getRecipeEnergyMultiplier();
    private final IOutputHandler<// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull ElectrolysisRecipe.ElectrolysisRecipeOutput> outputHandler;
    private final IInputHandler<@NotNull FluidStack> inputHandler;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getInput", "getInputCapacity", "getInputNeeded", "getInputFilledPercentage"}, docPlaceholder="input tank")
    public BasicFluidTank fluidTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getLeftOutput", "getLeftOutputCapacity", "getLeftOutputNeeded", "getLeftOutputFilledPercentage"}, docPlaceholder="left output tank")
    public IChemicalTank leftTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getRightOutput", "getRightOutputCapacity", "getRightOutputNeeded", "getRightOutputFilledPercentage"}, docPlaceholder="right output tank")
    public IChemicalTank rightTank;
    @SyntheticComputerMethod(getter="getLeftOutputDumpingMode")
    public TileEntityChemicalTank.GasMode dumpLeft = TileEntityChemicalTank.GasMode.IDLE;
    @SyntheticComputerMethod(getter="getRightOutputDumpingMode")
    public TileEntityChemicalTank.GasMode dumpRight = TileEntityChemicalTank.GasMode.IDLE;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"}, docPlaceholder="input item slot")
    FluidInventorySlot fluidSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getLeftOutputItem"}, docPlaceholder="left output item slot")
    ChemicalInventorySlot leftOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getRightOutputItem"}, docPlaceholder="right output item slot")
    ChemicalInventorySlot rightOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;
    private int numPowering;
    private long clientEnergyUsed = 1L;
    private long recipeEnergyMultiplier = 1L;
    private int baselineMaxOperations = 1;
    private long dumpRate = 8L;
    private int baseOperations = 8;
    private FixedUsageEnergyContainer<TileEntityLargeElectrolyticSeparator> energyContainer;

    public TileEntityLargeElectrolyticSeparator(BlockPos pos, BlockState state) {
        super(LargeMachineBlocks.LARGE_ELECTROLYTIC_SEPARATOR, pos, state, TRACKED_ERROR_TYPES);
        ConfigInfo gasConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.fluidSlot}));
            itemConfig.addSlotInfo(DataType.OUTPUT_1, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.leftOutputSlot}));
            itemConfig.addSlotInfo(DataType.OUTPUT_2, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.rightOutputSlot}));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.fluidSlot, this.leftOutputSlot, this.rightOutputSlot}));
            itemConfig.addSlotInfo(DataType.ENERGY, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.energySlot}));
        }
        if ((gasConfig = this.configComponent.getConfig(TransmissionType.CHEMICAL)) != null) {
            gasConfig.addSlotInfo(DataType.OUTPUT_1, (ISlotInfo)new ChemicalSlotInfo(false, true, new IChemicalTank[]{this.leftTank}));
            gasConfig.addSlotInfo(DataType.OUTPUT_2, (ISlotInfo)new ChemicalSlotInfo(false, true, new IChemicalTank[]{this.rightTank}));
        }
        this.configComponent.setupInputConfig(TransmissionType.FLUID, (Object)this.fluidTank);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL}).setCanTankEject(tank -> {
            if (tank == this.leftTank) {
                return this.dumpLeft != TileEntityChemicalTank.GasMode.DUMPING;
            }
            if (tank == this.rightTank) {
                return this.dumpRight != TileEntityChemicalTank.GasMode.DUMPING;
            }
            return true;
        });
        this.inputHandler = InputHelper.getInputHandler((IExtendedFluidTank)this.fluidTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler((IChemicalTank)this.leftTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_LEFT_OUTPUT_ERROR, (IChemicalTank)this.rightTank, (CachedRecipe.OperationTracker.RecipeError)NOT_ENOUGH_SPACE_RIGHT_OUTPUT_ERROR);
    }

    @NotNull
    protected IFluidTankHolder getInitialFluidTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        CanAdjustFluidTankHelper builder = CanAdjustFluidTankHelper.forSide(this.facingSupplier, side -> side == RelativeSide.BACK || side == RelativeSide.LEFT || side == RelativeSide.RIGHT, null);
        this.fluidTank = BasicFluidTank.input((int)24000000, arg_0 -> ((TileEntityLargeElectrolyticSeparator)this).containsRecipe(arg_0), (IContentsListener)recipeCacheListener);
        builder.addTank(this.fluidTank, RelativeSide.BACK, RelativeSide.LEFT, RelativeSide.RIGHT);
        return builder.build();
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        CanAdjustChemicalTankHelper builder = CanAdjustChemicalTankHelper.forSide(this.facingSupplier, null, side -> side == RelativeSide.LEFT || side == RelativeSide.RIGHT);
        this.leftTank = BasicChemicalTank.output((long)24000000L, (IContentsListener)recipeCacheUnpauseListener);
        builder.addTank(this.leftTank, RelativeSide.LEFT);
        this.rightTank = BasicChemicalTank.output((long)24000000L, (IContentsListener)recipeCacheUnpauseListener);
        builder.addTank(this.rightTank, RelativeSide.RIGHT);
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide((Supplier)this.facingSupplier);
        this.energyContainer = FixedUsageEnergyContainer.input((TileEntityMekanism)this, BASE_ENERGY_CALCULATOR, (IContentsListener)recipeCacheUnpauseListener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier);
        this.fluidSlot = FluidInventorySlot.fill((IExtendedFluidTank)this.fluidTank, (IContentsListener)listener, (int)26, (int)35);
        builder.addSlot((IInventorySlot)this.fluidSlot, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT, RelativeSide.BACK});
        this.leftOutputSlot = ChemicalInventorySlot.drain((IChemicalTank)this.leftTank, (IContentsListener)listener, (int)59, (int)52);
        builder.addSlot((IInventorySlot)this.leftOutputSlot, new RelativeSide[]{RelativeSide.LEFT});
        this.rightOutputSlot = ChemicalInventorySlot.drain((IChemicalTank)this.rightTank, (IContentsListener)listener, (int)101, (int)52);
        builder.addSlot((IInventorySlot)this.rightOutputSlot, new RelativeSide[]{RelativeSide.RIGHT});
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityLargeElectrolyticSeparator)this).getLevel(), (IContentsListener)listener, (int)143, (int)35);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.BACK});
        this.fluidSlot.setSlotType(ContainerSlotType.INPUT);
        this.leftOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.rightOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        return builder.build();
    }

    public void onCachedRecipeChanged(@Nullable CachedRecipe<ElectrolysisRecipe> cachedRecipe, int cacheIndex) {
        super.onCachedRecipeChanged(cachedRecipe, cacheIndex);
        this.recipeEnergyMultiplier = cachedRecipe == null ? 1L : ((ElectrolysisRecipe)cachedRecipe.getRecipe()).getEnergyMultiplier();
        this.energyContainer.updateEnergyPerTick();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.fluidSlot.fillTank();
        this.leftOutputSlot.drainTank();
        this.rightOutputSlot.drainTank();
        this.clientEnergyUsed = this.recipeCacheLookupMonitor.updateAndProcess(this.energyContainer);
        this.handleTank(this.leftTank, this.dumpLeft);
        this.handleTank(this.rightTank, this.dumpRight);
        return sendUpdatePacket;
    }

    private void handleTank(IChemicalTank tank, TileEntityChemicalTank.GasMode mode) {
        if (!tank.isEmpty()) {
            long stored;
            long target;
            if (mode == TileEntityChemicalTank.GasMode.DUMPING) {
                tank.shrinkStack(this.dumpRate, Action.EXECUTE);
            } else if (mode == TileEntityChemicalTank.GasMode.DUMPING_EXCESS && (target = this.getDumpingExcessTarget(tank)) < (stored = tank.getStored())) {
                tank.shrinkStack(Math.min(stored - target, MekanismConfig.general.chemicalAutoEjectRate.get() * 10L), Action.EXECUTE);
            }
        }
    }

    private long getDumpingExcessTarget(IChemicalTank tank) {
        return MathUtils.clampToLong((double)((double)tank.getCapacity() * MekanismConfig.general.dumpExcessKeepRatio.get()));
    }

    private boolean atDumpingExcessTarget(IChemicalTank tank) {
        return tank.getStored() >= this.getDumpingExcessTarget(tank);
    }

    public boolean canFunction() {
        return super.canFunction() && (this.dumpLeft != TileEntityChemicalTank.GasMode.DUMPING_EXCESS || this.dumpRight != TileEntityChemicalTank.GasMode.DUMPING_EXCESS || !this.atDumpingExcessTarget(this.leftTank) || !this.atDumpingExcessTarget(this.rightTank));
    }

    @ComputerMethod(nameOverride="getEnergyUsage", methodDescription="Get the energy used in the last tick by the machine")
    public long getEnergyUsed() {
        return this.clientEnergyUsed;
    }

    @Override
    public boolean needConfig() {
        return false;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<SingleFluidRecipeInput, ElectrolysisRecipe, InputRecipeCache.SingleFluid<ElectrolysisRecipe>> getRecipeType() {
        return MekanismRecipeType.SEPARATING;
    }

    public IRecipeViewerRecipeType<ElectrolysisRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.SEPARATING;
    }

    @Nullable
    public ElectrolysisRecipe getRecipe(int cacheIndex) {
        return (ElectrolysisRecipe)this.findFirstRecipe(this.inputHandler);
    }

    @NotNull
    public CachedRecipe<ElectrolysisRecipe> createNewCachedRecipe(@NotNull ElectrolysisRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.separating((ElectrolysisRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors, this.inputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(this::canFunction).setActive(arg_0 -> ((TileEntityLargeElectrolyticSeparator)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setBaselineMaxOperations(() -> this.baseOperations * this.baselineMaxOperations).setOnFinish(() -> ((TileEntityLargeElectrolyticSeparator)this).markForSave());
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            int upgradeCount = this.upgradeComponent.getUpgrades(Upgrade.SPEED);
            double speed = Math.pow(2.0, upgradeCount);
            this.baseOperations = 4 * (upgradeCount > 0 ? upgradeCount : upgradeCount + 1);
            this.baselineMaxOperations = (int)speed;
            this.dumpRate = (long)(8.0 * speed);
        }
    }

    public void nextMode(int tank) {
        if (tank == 0) {
            this.dumpLeft = (TileEntityChemicalTank.GasMode)this.dumpLeft.getNext();
            this.markForSave();
        } else if (tank == 1) {
            this.dumpRight = (TileEntityChemicalTank.GasMode)this.dumpRight.getNext();
            this.markForSave();
        }
    }

    public void writeSustainedData(HolderLookup.Provider provider, CompoundTag dataMap) {
        super.writeSustainedData(provider, dataMap);
        NBTUtils.writeEnum((CompoundTag)dataMap, (String)"dump_left", (Enum)this.dumpLeft);
        NBTUtils.writeEnum((CompoundTag)dataMap, (String)"dump_right", (Enum)this.dumpRight);
    }

    public void readSustainedData(HolderLookup.Provider provider, @NotNull CompoundTag dataMap) {
        super.readSustainedData(provider, dataMap);
        NBTUtils.setEnumIfPresent((CompoundTag)dataMap, (String)"dump_left", (IntFunction)TileEntityChemicalTank.GasMode.BY_ID, mode -> {
            this.dumpLeft = mode;
        });
        NBTUtils.setEnumIfPresent((CompoundTag)dataMap, (String)"dump_right", (IntFunction)TileEntityChemicalTank.GasMode.BY_ID, mode -> {
            this.dumpRight = mode;
        });
    }

    protected void collectImplicitComponents(@NotNull DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        builder.set((Supplier)MekanismDataComponents.DUMP_MODE, (Object)this.dumpLeft);
        builder.set((Supplier)MekanismDataComponents.SECONDARY_DUMP_MODE, (Object)this.dumpRight);
    }

    protected void applyImplicitComponents(@NotNull BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.dumpLeft = (TileEntityChemicalTank.GasMode)input.getOrDefault((Supplier)MekanismDataComponents.DUMP_MODE, (Object)this.dumpLeft);
        this.dumpRight = (TileEntityChemicalTank.GasMode)input.getOrDefault((Supplier)MekanismDataComponents.SECONDARY_DUMP_MODE, (Object)this.dumpRight);
    }

    public int getRedstoneLevel() {
        return MekanismUtils.redstoneLevelFromContents((long)this.fluidTank.getFluidAmount(), (long)this.fluidTank.getCapacity());
    }

    protected boolean makesComparatorDirty(ContainerType<?, ?, ?> type) {
        return type == ContainerType.FLUID;
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableEnum.create((IntFunction)TileEntityChemicalTank.GasMode.BY_ID, (Enum)TileEntityChemicalTank.GasMode.IDLE, () -> this.dumpLeft, value -> {
            this.dumpLeft = value;
        }));
        container.track((ISyncableData)SyncableEnum.create((IntFunction)TileEntityChemicalTank.GasMode.BY_ID, (Enum)TileEntityChemicalTank.GasMode.IDLE, () -> this.dumpRight, value -> {
            this.dumpRight = value;
        }));
        container.track((ISyncableData)SyncableLong.create(this::getEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }

    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction direction = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction left = this.getLeftSide();
        Direction right = left.getOpposite();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                if (!offset.equals((Object)new Vec3i(left.getStepX(), 0, back.getStepZ())) && !offset.equals((Object)new Vec3i(right.getStepX(), 0, back.getStepZ()))) break;
                return this.getCurrentRedstoneLevel();
            }
            case WEST: 
            case EAST: {
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, left.getStepZ())) && !offset.equals((Object)new Vec3i(back.getStepX(), 0, right.getStepZ()))) break;
                return this.getCurrentRedstoneLevel();
            }
        }
        return 0;
    }

    @Nullable
    public <T> T getOffsetCapabilityIfEnabled(@NotNull BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.ENERGY.block()) {
            return (T)Objects.requireNonNull(this.energyHandlerManager, "Expected to have energy handler").resolve(capability, side);
        }
        if (capability == Capabilities.FLUID.block()) {
            return (T)Objects.requireNonNull(this.fluidHandlerManager, "Expected to have fluid handler").resolve(capability, side);
        }
        if (capability == Capabilities.CHEMICAL.block()) {
            return (T)Objects.requireNonNull(this.chemicalHandlerManager, "Expected to have chemical handler").resolve(capability, side);
        }
        if (capability == Capabilities.ITEM.block()) {
            return (T)Objects.requireNonNull(this.itemHandlerManager, "Expected to have item handler").resolve(capability, side);
        }
        return (T)WorldUtils.getCapability((Level)this.level, capability, (BlockPos)this.worldPosition, null, (BlockEntity)this, (Object)side);
    }

    public boolean isOffsetCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.FLUID.block()) {
            return this.notFluidPort(side, offset);
        }
        if (capability == Capabilities.CHEMICAL.block()) {
            return this.notChemicalPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        if (capability == Capabilities.ITEM.block()) {
            return this.notItemPort(side, offset);
        }
        return this.notFluidPort(side, offset) && this.notChemicalPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notChemicalPort(Direction side, Vec3i offset) {
        Direction front = this.getDirection();
        Direction left = this.getLeftSide();
        Direction right = left.getOpposite();
        switch (front) {
            case NORTH: 
            case SOUTH: {
                if (offset.equals((Object)new Vec3i(left.getStepX(), 0, front.getStepZ()))) {
                    return side != left;
                }
                if (!offset.equals((Object)new Vec3i(right.getStepX(), 0, front.getStepZ()))) break;
                return side != right;
            }
            case WEST: 
            case EAST: {
                if (offset.equals((Object)new Vec3i(front.getStepX(), 0, left.getStepZ()))) {
                    return side != left;
                }
                if (!offset.equals((Object)new Vec3i(front.getStepX(), 0, right.getStepZ()))) break;
                return side != right;
            }
        }
        return true;
    }

    private boolean notFluidPort(Direction side, Vec3i offset) {
        Direction direction = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction left = this.getLeftSide();
        Direction right = left.getOpposite();
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                if (offset.equals((Object)new Vec3i(left.getStepX(), 0, back.getStepZ()))) {
                    return side != back && side != left;
                }
                if (!offset.equals((Object)new Vec3i(right.getStepX(), 0, back.getStepZ()))) break;
                return side != back && side != right;
            }
            case WEST: 
            case EAST: {
                if (offset.equals((Object)new Vec3i(back.getStepX(), 0, left.getStepZ()))) {
                    return side != back && side != left;
                }
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, right.getStepZ()))) break;
                return side != back && side != right;
            }
        }
        return true;
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        return this.notChemicalPort(side, offset) && this.notFluidPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notEnergyPort(Direction side, Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ()))) {
            return side != back;
        }
        return true;
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setLeftOutputDumpingMode(TileEntityChemicalTank.GasMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.dumpLeft != mode) {
            this.dumpLeft = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementLeftOutputDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode(0);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementLeftOutputDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dumpLeft = (TileEntityChemicalTank.GasMode)this.dumpLeft.getPrevious();
        this.markForSave();
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void setRightOutputDumpingMode(TileEntityChemicalTank.GasMode mode) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.dumpRight != mode) {
            this.dumpRight = mode;
            this.markForSave();
        }
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void incrementRightOutputDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.nextMode(1);
    }

    @ComputerMethod(requiresPublicSecurity=true)
    void decrementRightOutputDumpingMode() throws ComputerException {
        this.validateSecurityIsPublic();
        this.dumpRight = (TileEntityChemicalTank.GasMode)this.dumpRight.getPrevious();
        this.markForSave();
    }

    @Generated
    public long getRecipeEnergyMultiplier() {
        return this.recipeEnergyMultiplier;
    }

    @Generated
    public FixedUsageEnergyContainer<TileEntityLargeElectrolyticSeparator> getEnergyContainer() {
        return this.energyContainer;
    }
}

