/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.meklm.common.tile.machine;

import com.jerry.meklm.common.capabilities.holder.chemical.CanAdjustChemicalTankHelper;
import com.jerry.meklm.common.registries.LargeMachineBlocks;
import com.jerry.meklm.common.tile.INeedConfig;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.ChemicalChemicalToChemicalRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ChemicalChemicalToChemicalCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.api.recipes.vanilla_input.BiChemicalRecipeInput;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.ISyncableData;
import mekanism.common.inventory.container.sync.SyncableLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.chemical.ChemicalInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.IEitherSideRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.tile.component.config.slot.InventorySlotInfo;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityLargeChemicalInfuser
extends TileEntityRecipeMachine<ChemicalChemicalToChemicalRecipe>
implements IBoundingBlock,
IEitherSideRecipeLookupHandler.EitherSideChemicalRecipeLookupHandler<ChemicalChemicalToChemicalRecipe>,
INeedConfig {
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY_REDUCED_RATE, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_LEFT_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    public static final long MAX_GAS = 5000000L;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getLeftInput", "getLeftInputCapacity", "getLeftInputNeeded", "getLeftInputFilledPercentage"}, docPlaceholder="left input tank")
    public IChemicalTank leftTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getRightInput", "getRightInputCapacity", "getRightInputNeeded", "getRightInputFilledPercentage"}, docPlaceholder="right input tank")
    public IChemicalTank rightTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getOutput", "getOutputCapacity", "getOutputNeeded", "getOutputFilledPercentage"}, docPlaceholder="output (center) tank")
    public IChemicalTank centerTank;
    private long clientEnergyUsed = 0L;
    private int baselineMaxOperations = 1;
    private int baseOperations = 8;
    private int numPowering;
    private final IOutputHandler<@NotNull ChemicalStack> outputHandler;
    private final IInputHandler<@NotNull ChemicalStack> leftInputHandler;
    private final IInputHandler<@NotNull ChemicalStack> rightInputHandler;
    private MachineEnergyContainer<TileEntityLargeChemicalInfuser> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getLeftInputItem"}, docPlaceholder="left input item slot")
    ChemicalInventorySlot leftInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"}, docPlaceholder="output item slot")
    ChemicalInventorySlot outputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getRightInputItem"}, docPlaceholder="right input item slot")
    ChemicalInventorySlot rightInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"}, docPlaceholder="energy slot")
    EnergyInventorySlot energySlot;

    public TileEntityLargeChemicalInfuser(BlockPos pos, BlockState state) {
        super(LargeMachineBlocks.LARGE_CHEMICAL_INFUSER, pos, state, TRACKED_ERROR_TYPES);
        ConfigInfo gasConfig;
        ConfigInfo itemConfig = this.configComponent.getConfig(TransmissionType.ITEM);
        if (itemConfig != null) {
            itemConfig.addSlotInfo(DataType.INPUT_1, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.leftInputSlot}));
            itemConfig.addSlotInfo(DataType.INPUT_2, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.rightInputSlot}));
            itemConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.outputSlot}));
            itemConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.leftInputSlot, this.rightInputSlot, this.outputSlot}));
            itemConfig.addSlotInfo(DataType.ENERGY, (ISlotInfo)new InventorySlotInfo(true, true, new IInventorySlot[]{this.energySlot}));
        }
        if ((gasConfig = this.configComponent.getConfig(TransmissionType.CHEMICAL)) != null) {
            gasConfig.addSlotInfo(DataType.INPUT_1, (ISlotInfo)new ChemicalSlotInfo(true, false, new IChemicalTank[]{this.leftTank}));
            gasConfig.addSlotInfo(DataType.INPUT_2, (ISlotInfo)new ChemicalSlotInfo(true, false, new IChemicalTank[]{this.rightTank}));
            gasConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo(false, true, new IChemicalTank[]{this.centerTank}));
            gasConfig.addSlotInfo(DataType.INPUT_OUTPUT, (ISlotInfo)new ChemicalSlotInfo(true, true, new IChemicalTank[]{this.leftTank, this.rightTank, this.centerTank}));
        }
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL}).setCanTankEject(tank -> tank == this.centerTank);
        this.leftInputHandler = InputHelper.getInputHandler((IChemicalTank)this.leftTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_LEFT_INPUT);
        this.rightInputHandler = InputHelper.getInputHandler((IChemicalTank)this.rightTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_RIGHT_INPUT);
        this.outputHandler = OutputHelper.getOutputHandler((IChemicalTank)this.centerTank, (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
    }

    @NotNull
    public IChemicalTankHolder getInitialChemicalTanks(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        CanAdjustChemicalTankHelper builder = CanAdjustChemicalTankHelper.forSide(this.facingSupplier, side -> side == RelativeSide.LEFT || side == RelativeSide.RIGHT || side == RelativeSide.BACK, side -> side == RelativeSide.FRONT);
        this.leftTank = BasicChemicalTank.inputModern((long)5000000L, gas -> this.containsRecipe(gas, this.rightTank.getStack()), arg_0 -> ((TileEntityLargeChemicalInfuser)this).containsRecipe(arg_0), (IContentsListener)recipeCacheListener);
        builder.addTank(this.leftTank, RelativeSide.BACK, RelativeSide.LEFT);
        this.rightTank = BasicChemicalTank.inputModern((long)5000000L, gas -> this.containsRecipe(gas, this.leftTank.getStack()), arg_0 -> ((TileEntityLargeChemicalInfuser)this).containsRecipe(arg_0), (IContentsListener)recipeCacheListener);
        builder.addTank(this.rightTank, RelativeSide.BACK, RelativeSide.RIGHT);
        this.centerTank = BasicChemicalTank.output((long)10000000L, (IContentsListener)recipeCacheUnpauseListener);
        builder.addTank(this.centerTank, RelativeSide.FRONT);
        return builder.build();
    }

    @NotNull
    protected IEnergyContainerHolder getInitialEnergyContainers(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide((Supplier)this.facingSupplier);
        this.energyContainer = MachineEnergyContainer.input((TileEntityMekanism)this, (IContentsListener)recipeCacheUnpauseListener);
        builder.addContainer((IEnergyContainer)this.energyContainer, new RelativeSide[]{RelativeSide.BACK});
        return builder.build();
    }

    @NotNull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener, IContentsListener recipeCacheListener, IContentsListener recipeCacheUnpauseListener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide((Supplier)this.facingSupplier, side -> side == RelativeSide.LEFT || side == RelativeSide.RIGHT, side -> side == RelativeSide.FRONT || side == RelativeSide.BACK);
        this.leftInputSlot = ChemicalInventorySlot.fill((IChemicalTank)this.leftTank, (IContentsListener)listener, (int)6, (int)56);
        builder.addSlot((IInventorySlot)this.leftInputSlot, new RelativeSide[]{RelativeSide.LEFT});
        this.rightInputSlot = ChemicalInventorySlot.fill((IChemicalTank)this.rightTank, (IContentsListener)listener, (int)154, (int)56);
        builder.addSlot((IInventorySlot)this.rightInputSlot, new RelativeSide[]{RelativeSide.RIGHT});
        this.outputSlot = ChemicalInventorySlot.drain((IChemicalTank)this.centerTank, (IContentsListener)listener, (int)80, (int)65);
        builder.addSlot((IInventorySlot)this.outputSlot, new RelativeSide[]{RelativeSide.BACK, RelativeSide.FRONT});
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityLargeChemicalInfuser)this).getLevel(), (IContentsListener)listener, (int)154, (int)14);
        builder.addSlot((IInventorySlot)this.energySlot, new RelativeSide[]{RelativeSide.LEFT, RelativeSide.RIGHT});
        this.leftInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.leftInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.rightInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.rightInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.leftInputSlot.fillTank();
        this.rightInputSlot.fillTank();
        this.outputSlot.drainTank();
        this.clientEnergyUsed = this.recipeCacheLookupMonitor.updateAndProcess(this.energyContainer);
        return sendUpdatePacket;
    }

    @ComputerMethod(nameOverride="getEnergyUsage", methodDescription="Get the energy used in the last tick by the machine")
    public long getEnergyUsed() {
        return this.clientEnergyUsed;
    }

    @Override
    public boolean needConfig() {
        return false;
    }

    @NotNull
    public IMekanismRecipeTypeProvider<BiChemicalRecipeInput, ChemicalChemicalToChemicalRecipe, InputRecipeCache.EitherSideChemical<ChemicalChemicalToChemicalRecipe>> getRecipeType() {
        return MekanismRecipeType.CHEMICAL_INFUSING;
    }

    public IRecipeViewerRecipeType<ChemicalChemicalToChemicalRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.CHEMICAL_INFUSING;
    }

    @Nullable
    public ChemicalChemicalToChemicalRecipe getRecipe(int cacheIndex) {
        return (ChemicalChemicalToChemicalRecipe)this.findFirstRecipe(this.leftInputHandler, this.rightInputHandler);
    }

    @NotNull
    public CachedRecipe<ChemicalChemicalToChemicalRecipe> createNewCachedRecipe(@NotNull ChemicalChemicalToChemicalRecipe recipe, int cacheIndex) {
        return new ChemicalChemicalToChemicalCachedRecipe(recipe, this.recheckAllRecipeErrors, this.leftInputHandler, this.rightInputHandler, this.outputHandler).setErrorsChanged(x$0 -> this.onErrorsChanged((Set)x$0)).setCanHolderFunction(() -> ((TileEntityLargeChemicalInfuser)this).canFunction()).setActive(arg_0 -> ((TileEntityLargeChemicalInfuser)this).setActive(arg_0)).setEnergyRequirements(() -> this.energyContainer.getEnergyPerTick(), this.energyContainer).setBaselineMaxOperations(() -> this.baseOperations * this.baselineMaxOperations).setOnFinish(() -> ((TileEntityLargeChemicalInfuser)this).markForSave());
    }

    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.SPEED) {
            int upgradeCount = this.upgradeComponent.getUpgrades(Upgrade.SPEED);
            this.baseOperations = 4 * (upgradeCount > 0 ? upgradeCount : upgradeCount + 1);
            this.baselineMaxOperations = (int)Math.pow(2.0, upgradeCount);
        }
    }

    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track((ISyncableData)SyncableLong.create(this::getEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }

    public boolean isPowered() {
        return this.redstone || this.numPowering > 0;
    }

    public void onBoundingBlockPowerChange(BlockPos boundingPos, int oldLevel, int newLevel) {
        if (oldLevel > 0) {
            if (newLevel == 0) {
                --this.numPowering;
            }
        } else if (newLevel > 0) {
            ++this.numPowering;
        }
    }

    public int getBoundingComparatorSignal(Vec3i offset) {
        Direction direction = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction left = this.getLeftSide();
        Direction right = left.getOpposite();
        switch (direction) {
            case NORTH: 
            case SOUTH: {
                if (!offset.equals((Object)new Vec3i(left.getStepX(), 0, back.getStepZ())) && !offset.equals((Object)new Vec3i(right.getStepX(), 0, back.getStepZ()))) break;
                return this.getCurrentRedstoneLevel();
            }
            case WEST: 
            case EAST: {
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, left.getStepZ())) && !offset.equals((Object)new Vec3i(back.getStepX(), 0, right.getStepZ()))) break;
                return this.getCurrentRedstoneLevel();
            }
        }
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ()))) {
            return this.getCurrentRedstoneLevel();
        }
        return 0;
    }

    @Nullable
    public <T> T getOffsetCapabilityIfEnabled(@NotNull BlockCapability<T, @Nullable Direction> capability, @Nullable Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.ENERGY.block()) {
            return (T)Objects.requireNonNull(this.energyHandlerManager, "Expected to have energy handler").resolve(capability, side);
        }
        if (capability == Capabilities.CHEMICAL.block()) {
            return (T)Objects.requireNonNull(this.chemicalHandlerManager, "Expected to have chemical handler").resolve(capability, side);
        }
        if (capability == Capabilities.ITEM.block()) {
            return (T)Objects.requireNonNull(this.itemHandlerManager, "Expected to have item handler").resolve(capability, side);
        }
        return (T)WorldUtils.getCapability((Level)this.level, capability, (BlockPos)this.worldPosition, null, (BlockEntity)this, (Object)side);
    }

    public boolean isOffsetCapabilityDisabled(@NotNull BlockCapability<?, @Nullable Direction> capability, Direction side, @NotNull Vec3i offset) {
        if (capability == Capabilities.CHEMICAL.block()) {
            return this.notChemicalPort(side, offset);
        }
        if (EnergyCompatUtils.isEnergyCapability(capability)) {
            return this.notEnergyPort(side, offset);
        }
        if (capability == Capabilities.ITEM.block()) {
            return this.notItemPort(side, offset);
        }
        return this.notChemicalPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notChemicalPort(Direction side, Vec3i offset) {
        Direction front = this.getDirection();
        Direction back = this.getOppositeDirection();
        Direction left = this.getLeftSide();
        Direction right = left.getOpposite();
        switch (front) {
            case NORTH: 
            case SOUTH: {
                if (offset.equals((Object)new Vec3i(left.getStepX(), 0, front.getStepZ())) || offset.equals((Object)new Vec3i(right.getStepX(), 0, front.getStepZ()))) {
                    return side != front;
                }
                if (offset.equals((Object)new Vec3i(left.getStepX(), 0, back.getStepZ()))) {
                    return side != back && side != left;
                }
                if (!offset.equals((Object)new Vec3i(right.getStepX(), 0, back.getStepZ()))) break;
                return side != back && side != right;
            }
            case WEST: 
            case EAST: {
                if (offset.equals((Object)new Vec3i(front.getStepX(), 0, left.getStepZ())) || offset.equals((Object)new Vec3i(front.getStepX(), 0, right.getStepZ()))) {
                    return side != front;
                }
                if (offset.equals((Object)new Vec3i(back.getStepX(), 0, left.getStepZ()))) {
                    return side != back && side != left;
                }
                if (!offset.equals((Object)new Vec3i(back.getStepX(), 0, right.getStepZ()))) break;
                return side != back && side != right;
            }
        }
        return true;
    }

    private boolean notItemPort(Direction side, Vec3i offset) {
        return this.notChemicalPort(side, offset) && this.notEnergyPort(side, offset);
    }

    private boolean notEnergyPort(Direction side, Vec3i offset) {
        Direction back = this.getOppositeDirection();
        if (offset.equals((Object)new Vec3i(back.getStepX(), 0, back.getStepZ()))) {
            return side != back;
        }
        return true;
    }

    @Generated
    public MachineEnergyContainer<TileEntityLargeChemicalInfuser> getEnergyContainer() {
        return this.energyContainer;
    }
}

