/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.factory;

import com.jerry.mekaf.common.tile.factory.TileEntityChemicalToChemicalFactory;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ChemicalToChemicalRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IBoundingBlock;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntitySolarNeutronActivatingFactory
extends TileEntityChemicalToChemicalFactory<ChemicalToChemicalRecipe>
implements IBoundingBlock,
ISingleRecipeLookupHandler.ChemicalRecipeLookupHandler<ChemicalToChemicalRecipe> {
    protected static final TriPredicate<ChemicalToChemicalRecipe, ChemicalStack, ChemicalStack> OUTPUT_CHECK = (recipe, input, output) -> ChemicalStack.isSameChemical((ChemicalStack)recipe.getOutput(input), (ChemicalStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY);
    private float peakProductionRate;
    private float productionRate;
    private boolean settingsChecked;
    private boolean needsRainCheck;

    public TileEntitySolarNeutronActivatingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM, TransmissionType.CHEMICAL}).setCanTankEject(tank -> !this.inputChemicalTanks.contains(tank));
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
    }

    private void recheckSettings() {
        Level world = this.getLevel();
        if (world == null) {
            return;
        }
        BlockPos pos = this.getBlockPos();
        Biome b = (Biome)world.getBiomeManager().getBiome(pos).value();
        this.needsRainCheck = b.getPrecipitationAt(pos) != Biome.Precipitation.NONE;
        float tempEff = 0.3f * (0.8f - b.getTemperature(pos));
        float humidityEff = this.needsRainCheck ? -0.3f * b.getModifiedClimateSettings().downfall() : 0.0f;
        this.peakProductionRate = (float)MekanismConfig.general.maxSolarNeutronActivatorRate.get() * (1.0f + tempEff + humidityEff);
        this.settingsChecked = true;
    }

    @Override
    protected boolean onUpdateServer() {
        boolean sendUpdatePacket = super.onUpdateServer();
        if (!this.settingsChecked) {
            this.recheckSettings();
        }
        this.productionRate = this.recalculateProductionRate();
        return sendUpdatePacket;
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ChemicalToChemicalRecipe> cached, @NotNull ChemicalStack stack) {
        return cached != null && ((ChemicalToChemicalRecipe)cached.getRecipe()).getInput().testType(stack);
    }

    @Override
    @Nullable
    protected ChemicalToChemicalRecipe findRecipe(int process, @NotNull ChemicalStack fallbackInput, @NotNull IChemicalTank outputSlot) {
        return (ChemicalToChemicalRecipe)((InputRecipeCache.SingleChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)outputSlot.getStack(), OUTPUT_CHECK);
    }

    @Override
    public boolean isChemicalValidForTank(@NotNull ChemicalStack stack) {
        return this.containsRecipe(stack);
    }

    @Override
    public boolean isValidInputChemical(@NotNull ChemicalStack stack) {
        return this.containsRecipe(stack);
    }

    @Override
    protected int getNeededInput(ChemicalToChemicalRecipe recipe, ChemicalStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInput().getNeededAmount(inputStack));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, ChemicalToChemicalRecipe, InputRecipeCache.SingleChemical<ChemicalToChemicalRecipe>> getRecipeType() {
        return MekanismRecipeType.ACTIVATING;
    }

    @Nullable
    public IRecipeViewerRecipeType<ChemicalToChemicalRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.ACTIVATING;
    }

    @Nullable
    public ChemicalToChemicalRecipe getRecipe(int cacheIndex) {
        return (ChemicalToChemicalRecipe)this.findFirstRecipe(this.chemicalInputHandlers[cacheIndex]);
    }

    @NotNull
    public CachedRecipe<ChemicalToChemicalRecipe> createNewCachedRecipe(@NotNull ChemicalToChemicalRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.chemicalToChemical((ChemicalToChemicalRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.chemicalInputHandlers[cacheIndex], (IOutputHandler)this.chemicalOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(this::canFunction).setActive(arg_0 -> ((TileEntitySolarNeutronActivatingFactory)this).setActive(arg_0)).setOnFinish(() -> ((TileEntitySolarNeutronActivatingFactory)this).markForSave()).setRequiredTicks(() -> this.productionRate > 0.0f && this.productionRate < 1.0f ? Mth.ceil((float)(1.0f / this.productionRate)) : 1).setBaselineMaxOperations(() -> this.productionRate > 0.0f && this.productionRate < 1.0f ? 1 : (int)this.productionRate);
    }

    boolean canSeeSun() {
        return WorldUtils.canSeeSun((Level)this.level, (BlockPos)this.worldPosition.above());
    }

    public boolean canFunction() {
        return super.canFunction() && this.canSeeSun();
    }

    private float recalculateProductionRate() {
        Level world = this.getLevel();
        if (world == null || !this.canFunction()) {
            return 0.0f;
        }
        float brightness = WorldUtils.getSunBrightness((Level)world, (float)1.0f);
        float production = this.peakProductionRate * brightness;
        if (this.needsRainCheck && (world.isRaining() || world.isThundering())) {
            production *= 0.2f;
        }
        return production;
    }
}

