/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.factory;

import com.jerry.mekaf.common.inventory.slot.AdvancedFactoryInputInventorySlot;
import com.jerry.mekaf.common.tile.factory.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.upgrade.ItemToChemicalUpgradeData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.ToIntBiFunction;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.chemical.BasicChemicalTank;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.warning.WarningTracker;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.lookup.monitor.FactoryRecipeCacheLookupMonitor;
import mekanism.common.tile.component.ITileComponent;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ChemicalSlotInfo;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.MekanismUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.ItemStackMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TileEntityItemToChemicalFactory<RECIPE extends MekanismRecipe<?>>
extends TileEntityAdvancedFactoryBase<RECIPE> {
    protected ICProcessInfo[] processInfoSlots;
    public IChemicalTank[] outputTank;
    AdvancedFactoryInputInventorySlot[] inputSlot;
    protected final List<IInventorySlot> inputItemSlots = new ArrayList<IInventorySlot>();
    public final List<IChemicalTank> outputChemicalTanks = new ArrayList<IChemicalTank>();

    protected TileEntityItemToChemicalFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state, List<CachedRecipe.OperationTracker.RecipeError> errorTypes, Set<CachedRecipe.OperationTracker.RecipeError> globalErrorTypes) {
        super(blockProvider, pos, state, errorTypes, globalErrorTypes);
        this.processInfoSlots = new ICProcessInfo[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.processInfoSlots[i] = new ICProcessInfo(i, this.inputSlot[i], this.outputTank[i]);
        }
        for (ICProcessInfo info : this.processInfoSlots) {
            this.inputItemSlots.add((IInventorySlot)info.inputSlot());
            this.outputChemicalTanks.add(info.outputTank());
        }
        ConfigInfo chemicalConfig = this.configComponent.getConfig(TransmissionType.CHEMICAL);
        if (chemicalConfig != null) {
            chemicalConfig.addSlotInfo(DataType.OUTPUT, (ISlotInfo)new ChemicalSlotInfo(false, true, this.outputChemicalTanks));
        }
        this.configComponent.setupItemIOConfig(this.inputItemSlots, Collections.emptyList(), (IInventorySlot)this.energySlot, false);
    }

    @Override
    protected void addTanks(ChemicalTankHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.outputTank = new IChemicalTank[this.tier.processes];
        this.chemicalOutputHandlers = new IOutputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            FactoryRecipeCacheLookupMonitor lookupMonitor = this.recipeCacheLookupMonitors[i];
            IContentsListener updateSortingAndUnpause = () -> {
                updateSortingListener.onContentsChanged();
                lookupMonitor.unpause();
            };
            this.outputTank[i] = BasicChemicalTank.output((long)(10000L * (long)this.tier.processes), (IContentsListener)updateSortingAndUnpause);
            builder.addTank(this.outputTank[i]);
            this.chemicalOutputHandlers[i] = OutputHelper.getOutputHandler((IChemicalTank)this.outputTank[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE);
        }
    }

    @Override
    protected void addSlots(InventorySlotHelper builder, IContentsListener listener, IContentsListener updateSortingListener) {
        this.inputSlot = new AdvancedFactoryInputInventorySlot[this.tier.processes];
        this.itemInputHandlers = new IInputHandler[this.tier.processes];
        for (int i = 0; i < this.tier.processes; ++i) {
            this.inputSlot[i] = AdvancedFactoryInputInventorySlot.create(this, i, this.outputTank[i], (IContentsListener)this.recipeCacheLookupMonitors[i], this.getXPos(i), 13);
            int index = i;
            ((AdvancedFactoryInputInventorySlot)builder.addSlot((IInventorySlot)this.inputSlot[i])).tracksWarnings(slot -> slot.warning(WarningTracker.WarningType.NO_MATCHING_RECIPE, this.getWarningCheck(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, index)));
            this.itemInputHandlers[i] = InputHelper.getInputHandler((IInventorySlot)this.inputSlot[i], (CachedRecipe.OperationTracker.RecipeError)CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT);
        }
    }

    public boolean inputProducesOutput(int process, @NotNull ItemStack fallbackInput, @NotNull IChemicalTank outputTank, boolean updateCache) {
        return outputTank.isEmpty() || this.getRecipeForInput(process, fallbackInput, outputTank, updateCache) != null;
    }

    @Contract(value="null, _ -> false")
    protected abstract boolean isCachedRecipeValid(@Nullable CachedRecipe<RECIPE> var1, @NotNull ItemStack var2);

    @Nullable
    protected RECIPE getRecipeForInput(int process, @NotNull ItemStack fallbackInput, @NotNull IChemicalTank outputTank, boolean updateCache) {
        CachedRecipe cached;
        if (!CommonWorldTickHandler.flushTagAndRecipeCaches && this.isCachedRecipeValid(cached = this.getCachedRecipe(process), fallbackInput)) {
            return (RECIPE)cached.getRecipe();
        }
        RECIPE foundRecipe = this.findRecipe(process, fallbackInput, outputTank);
        if (foundRecipe == null) {
            return null;
        }
        if (updateCache) {
            this.recipeCacheLookupMonitors[process].updateCachedRecipe(foundRecipe);
        }
        return foundRecipe;
    }

    @Nullable
    protected abstract RECIPE findRecipe(int var1, @NotNull ItemStack var2, @NotNull IChemicalTank var3);

    public abstract boolean isItemValidForSlot(@NotNull ItemStack var1);

    public abstract boolean isValidInputItem(@NotNull ItemStack var1);

    protected abstract int getNeededInput(RECIPE var1, ItemStack var2);

    public void parseUpgradeData(HolderLookup.Provider provider, @NotNull IUpgradeData upgradeData) {
        if (upgradeData instanceof ItemToChemicalUpgradeData) {
            int i;
            ItemToChemicalUpgradeData data = (ItemToChemicalUpgradeData)upgradeData;
            this.redstone = data.redstone;
            this.setControlType(data.controlType);
            this.getEnergyContainer().setEnergy(data.energyContainer.getEnergy());
            this.sorting = data.sorting;
            this.energySlot.deserializeNBT(provider, data.energySlot.serializeNBT(provider));
            System.arraycopy(data.progress, 0, this.progress, 0, data.progress.length);
            for (i = 0; i < data.inputSlots.size(); ++i) {
                this.inputItemSlots.get(i).deserializeNBT(provider, (Tag)data.inputSlots.get(i).serializeNBT(provider));
            }
            for (i = 0; i < data.outputTanks.size(); ++i) {
                this.outputChemicalTanks.get(i).setStack(data.outputTanks.get(i).getStack());
            }
            for (ITileComponent component : this.getComponents()) {
                component.read(data.components, provider);
            }
        } else {
            super.parseUpgradeData(provider, upgradeData);
        }
    }

    @Override
    protected void sortInventoryOrTank() {
        Map processes = ItemStackMap.createTypeAndTagMap();
        ArrayList<ICProcessInfo> emptyProcesses = new ArrayList<ICProcessInfo>();
        for (ICProcessInfo processInfo : this.processInfoSlots) {
            CachedRecipe cachedRecipe;
            AdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
            if (inputSlot.isEmpty()) {
                emptyProcesses.add(processInfo);
                continue;
            }
            ItemStack inputStack = inputSlot.getStack();
            ICRecipeProcessInfo recipeProcessInfo = processes.computeIfAbsent(inputStack, i -> new ICRecipeProcessInfo());
            recipeProcessInfo.processes.add(processInfo);
            recipeProcessInfo.totalCount += inputStack.getCount();
            if (recipeProcessInfo.lazyMinPerSlot != null || CommonWorldTickHandler.flushTagAndRecipeCaches || !this.isCachedRecipeValid(cachedRecipe = this.getCachedRecipe(processInfo.process()), inputStack)) continue;
            recipeProcessInfo.item = inputStack;
            recipeProcessInfo.recipe = cachedRecipe.getRecipe();
            recipeProcessInfo.lazyMinPerSlot = (info, factory) -> factory.getNeededInput(info.recipe, (ItemStack)info.item);
        }
        if (processes.isEmpty()) {
            return;
        }
        for (Map.Entry entry : processes.entrySet()) {
            ICRecipeProcessInfo recipeProcessInfo = (ICRecipeProcessInfo)entry.getValue();
            if (recipeProcessInfo.lazyMinPerSlot != null) continue;
            recipeProcessInfo.item = entry.getKey();
            recipeProcessInfo.lazyMinPerSlot = (info, factory) -> {
                ItemStack item = (ItemStack)info.item;
                ItemStack largerInput = item.copyWithCount(Math.min(item.getMaxStackSize(), info.totalCount));
                ICProcessInfo processInfo = info.processes.getFirst();
                info.recipe = factory.getRecipeForInput(processInfo.process(), largerInput, processInfo.outputTank(), true);
                if (info.recipe != null) {
                    return factory.getNeededInput(info.recipe, largerInput);
                }
                return 1;
            };
        }
        if (!emptyProcesses.isEmpty()) {
            this.addEmptySlotsAsTargets(processes, emptyProcesses);
        }
        this.distributeItems(processes);
    }

    protected void addEmptySlotsAsTargets(Map<ItemStack, ICRecipeProcessInfo<RECIPE>> processes, List<ICProcessInfo> emptyProcesses) {
        for (Map.Entry<ItemStack, ICRecipeProcessInfo<RECIPE>> entry : processes.entrySet()) {
            int processCount;
            ICRecipeProcessInfo<RECIPE> recipeProcessInfo = entry.getValue();
            int minPerSlot = recipeProcessInfo.getMinPerSlot(this);
            int maxSlots = recipeProcessInfo.totalCount / minPerSlot;
            if (maxSlots <= 1 || maxSlots <= (processCount = recipeProcessInfo.processes.size())) continue;
            ItemStack sourceStack = entry.getKey();
            int emptyToAdd = maxSlots - processCount;
            int added = 0;
            ArrayList<ICProcessInfo> toRemove = new ArrayList<ICProcessInfo>();
            for (ICProcessInfo emptyProcess : emptyProcesses) {
                if (!this.inputProducesOutput(emptyProcess.process(), sourceStack, emptyProcess.outputTank(), true)) continue;
                recipeProcessInfo.processes.add(emptyProcess);
                toRemove.add(emptyProcess);
                if (++added < emptyToAdd) continue;
                break;
            }
            emptyProcesses.removeAll(toRemove);
            if (!emptyProcesses.isEmpty()) continue;
            break;
        }
    }

    protected void distributeItems(Map<ItemStack, ICRecipeProcessInfo<RECIPE>> processes) {
        for (Map.Entry<ItemStack, ICRecipeProcessInfo<RECIPE>> entry : processes.entrySet()) {
            ItemStack item;
            int maxStackSize;
            int numberPerSlot;
            ICRecipeProcessInfo<RECIPE> recipeProcessInfo = entry.getValue();
            int processCount = recipeProcessInfo.processes.size();
            if (processCount == 1 || (numberPerSlot = recipeProcessInfo.totalCount / processCount) == (maxStackSize = (item = entry.getKey()).getMaxStackSize())) continue;
            int remainder = recipeProcessInfo.totalCount % processCount;
            int minPerSlot = recipeProcessInfo.getMinPerSlot(this);
            if (minPerSlot > 1) {
                int perSlotRemainder = numberPerSlot % minPerSlot;
                if (perSlotRemainder > 0) {
                    numberPerSlot -= perSlotRemainder;
                    remainder += perSlotRemainder * processCount;
                }
                if (numberPerSlot + minPerSlot > maxStackSize) {
                    minPerSlot = maxStackSize - numberPerSlot;
                }
            }
            for (int i = 0; i < processCount; ++i) {
                ICProcessInfo processInfo = recipeProcessInfo.processes.get(i);
                AdvancedFactoryInputInventorySlot inputSlot = processInfo.inputSlot();
                int sizeForSlot = numberPerSlot;
                if (remainder > 0) {
                    if (remainder > minPerSlot) {
                        sizeForSlot += minPerSlot;
                        remainder -= minPerSlot;
                    } else {
                        sizeForSlot += remainder;
                        remainder = 0;
                    }
                }
                if (inputSlot.isEmpty()) {
                    if (sizeForSlot <= 0) continue;
                    inputSlot.setStackUnchecked(item.copyWithCount(sizeForSlot));
                    continue;
                }
                if (sizeForSlot == 0) {
                    inputSlot.setEmpty();
                    continue;
                }
                if (inputSlot.getCount() == sizeForSlot) continue;
                MekanismUtils.logMismatchedStackSize((long)sizeForSlot, (long)inputSlot.setStackSize(sizeForSlot, Action.EXECUTE));
            }
        }
    }

    public record ICProcessInfo(int process, @NotNull AdvancedFactoryInputInventorySlot inputSlot, @NotNull IChemicalTank outputTank) {
    }

    protected static class ICRecipeProcessInfo<RECIPE extends MekanismRecipe<?>> {
        private final List<ICProcessInfo> processes = new ArrayList<ICProcessInfo>();
        @Nullable
        private ToIntBiFunction<ICRecipeProcessInfo<RECIPE>, TileEntityItemToChemicalFactory<RECIPE>> lazyMinPerSlot;
        private Object item;
        private RECIPE recipe;
        private int minPerSlot = 1;
        private int totalCount;

        protected ICRecipeProcessInfo() {
        }

        public int getMinPerSlot(TileEntityItemToChemicalFactory<RECIPE> factory) {
            if (this.lazyMinPerSlot != null) {
                this.minPerSlot = Math.max(1, this.lazyMinPerSlot.applyAsInt(this, factory));
                this.lazyMinPerSlot = null;
            }
            return this.minPerSlot;
        }
    }
}

