/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.tile.factory;

import com.jerry.mekaf.common.capabilities.energy.AdvancedFactoryEnergyContainer;
import com.jerry.mekaf.common.tile.factory.TileEntityChemicalToItemFactory;
import com.jerry.mekaf.common.upgrade.ChemicalToItemUpgradeData;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.OneInputCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.recipe_viewer.type.RecipeViewerRecipeType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.ISingleRecipeLookupHandler;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.upgrade.IUpgradeData;
import mekanism.common.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TileEntityCrystallizingFactory
extends TileEntityChemicalToItemFactory<ChemicalCrystallizerRecipe>
implements ISingleRecipeLookupHandler.ChemicalRecipeLookupHandler<ChemicalCrystallizerRecipe> {
    protected static final TriPredicate<ChemicalCrystallizerRecipe, ChemicalStack, ItemStack> OUTPUT_CHECK = (recipe, input, output) -> InventoryUtils.areItemsStackable((ItemStack)recipe.getOutput(input), (ItemStack)output);
    private static final List<CachedRecipe.OperationTracker.RecipeError> TRACKED_ERROR_TYPES = List.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_INPUT, CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_OUTPUT_SPACE, CachedRecipe.OperationTracker.RecipeError.INPUT_DOESNT_PRODUCE_OUTPUT);
    private static final Set<CachedRecipe.OperationTracker.RecipeError> GLOBAL_ERROR_TYPES = Set.of(CachedRecipe.OperationTracker.RecipeError.NOT_ENOUGH_ENERGY);

    public TileEntityCrystallizingFactory(Holder<Block> blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state, TRACKED_ERROR_TYPES, GLOBAL_ERROR_TYPES);
        this.ejectorComponent = new TileComponentEjector((TileEntityMekanism)this);
        this.ejectorComponent.setOutputData(this.configComponent, new TransmissionType[]{TransmissionType.ITEM});
    }

    @Override
    protected boolean isCachedRecipeValid(@Nullable CachedRecipe<ChemicalCrystallizerRecipe> cached, @NotNull ChemicalStack stack) {
        return cached != null && ((ChemicalCrystallizerRecipe)cached.getRecipe()).getInput().testType(stack);
    }

    @Override
    @Nullable
    protected ChemicalCrystallizerRecipe findRecipe(int process, @NotNull ChemicalStack fallbackInput, @NotNull IInventorySlot outputSlot) {
        return (ChemicalCrystallizerRecipe)((InputRecipeCache.SingleChemical)this.getRecipeType().getInputCache()).findTypeBasedRecipe(this.level, (Object)fallbackInput, (Object)outputSlot.getStack(), OUTPUT_CHECK);
    }

    @Override
    public boolean isChemicalValidForTank(@NotNull ChemicalStack stack) {
        return this.containsRecipe(stack);
    }

    @Override
    public boolean isValidInputChemical(@NotNull ChemicalStack stack) {
        return this.containsRecipe(stack);
    }

    @Override
    protected int getNeededInput(ChemicalCrystallizerRecipe recipe, ChemicalStack inputStack) {
        return MathUtils.clampToInt((long)recipe.getInput().getNeededAmount(inputStack));
    }

    @NotNull
    public IMekanismRecipeTypeProvider<?, ChemicalCrystallizerRecipe, InputRecipeCache.SingleChemical<ChemicalCrystallizerRecipe>> getRecipeType() {
        return MekanismRecipeType.CRYSTALLIZING;
    }

    @Nullable
    public IRecipeViewerRecipeType<ChemicalCrystallizerRecipe> recipeViewerType() {
        return RecipeViewerRecipeType.CRYSTALLIZING;
    }

    @Nullable
    public ChemicalCrystallizerRecipe getRecipe(int cacheIndex) {
        return (ChemicalCrystallizerRecipe)this.findFirstRecipe(this.chemicalInputHandlers[cacheIndex]);
    }

    @NotNull
    public CachedRecipe<ChemicalCrystallizerRecipe> createNewCachedRecipe(@NotNull ChemicalCrystallizerRecipe recipe, int cacheIndex) {
        return OneInputCachedRecipe.crystallizing((ChemicalCrystallizerRecipe)recipe, (BooleanSupplier)this.recheckAllRecipeErrors[cacheIndex], (IInputHandler)this.chemicalInputHandlers[cacheIndex], (IOutputHandler)this.itemOutputHandlers[cacheIndex]).setErrorsChanged(errors -> this.errorTracker.onErrorsChanged((Set<CachedRecipe.OperationTracker.RecipeError>)errors, cacheIndex)).setCanHolderFunction(() -> ((TileEntityCrystallizingFactory)this).canFunction()).setActive(active -> this.setActiveState(active, cacheIndex)).setEnergyRequirements(() -> ((AdvancedFactoryEnergyContainer)this.energyContainer).getEnergyPerTick(), (IEnergyContainer)this.energyContainer).setRequiredTicks(this::getTicksRequired).setOnFinish(() -> ((TileEntityCrystallizingFactory)this).markForSave()).setOperatingTicksChanged(operatingTicks -> {
            this.progress[cacheIndex] = operatingTicks;
        }).setBaselineMaxOperations(this::getOperationsPerTick);
    }

    @Nullable
    public IUpgradeData getUpgradeData(HolderLookup.Provider provider) {
        return new ChemicalToItemUpgradeData(provider, this.redstone, this.getControlType(), (IEnergyContainer)this.getEnergyContainer(), this.progress, this.energySlot, this.inputChemicalTanks, this.outputItemSlots, this.isSorting(), this.getComponents());
    }
}

