/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.registries;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.jerry.mekaf.common.attachments.containers.chemical.AFChemicalTanksBuilder;
import com.jerry.mekaf.common.attachments.containers.item.AFItemSlotsBuilder;
import com.jerry.mekaf.common.block.prefab.BlockAdvancedFactoryMachine;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactory;
import com.jerry.mekaf.common.content.blocktype.AdvancedFactoryType;
import com.jerry.mekaf.common.item.block.machine.ItemBlockAdvancedFactory;
import com.jerry.mekaf.common.registries.AdvancedFactoryBlockTypes;
import com.jerry.mekaf.common.tile.factory.TileEntityAdvancedFactoryBase;
import com.jerry.mekaf.common.tile.factory.TileEntityLiquifyingFactory;
import com.jerry.mekmm.common.util.MoreMachineEnumUtils;
import com.jerry.mekmm.common.util.MoreMachineUtils;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.tier.ITier;
import mekanism.common.attachments.containers.ContainerType;
import mekanism.common.attachments.containers.fluid.FluidTanksBuilder;
import mekanism.common.attachments.containers.item.ItemSlotsBuilder;
import mekanism.common.block.attribute.AttributeTier;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.DoubleInputRecipeCache;
import mekanism.common.recipe.lookup.cache.InputRecipeCache;
import mekanism.common.recipe.lookup.cache.TripleInputRecipeCache;
import mekanism.common.registration.impl.BlockDeferredRegister;
import mekanism.common.registration.impl.BlockRegistryObject;
import mekanism.common.tier.FactoryTier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class AdvancedFactoryBlocks {
    public static final BlockDeferredRegister AF_BLOCKS = new BlockDeferredRegister("mekmm");
    private static final Table<FactoryTier, AdvancedFactoryType, BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory>> AF_FACTORIES = HashBasedTable.create();

    private AdvancedFactoryBlocks() {
    }

    private static <TILE extends TileEntityAdvancedFactoryBase<?>> BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> registerAdvancedFactory(AdvancedFactory<TILE> type) {
        FactoryTier tier = (FactoryTier)Objects.requireNonNull((AttributeTier)type.get(AttributeTier.class)).tier();
        BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory, ItemBlockAdvancedFactory> factory = AdvancedFactoryBlocks.registerTieredBlock((ITier)tier, "_" + type.getAdvancedFactoryType().getRegistryNameComponent() + "_factory", () -> new BlockAdvancedFactoryMachine.BlockAdvancedFactory(type), ItemBlockAdvancedFactory::new);
        factory.forItemHolder(holder -> {
            int processes = tier.processes;
            Predicate<ItemStack> recipeItemInputPredicate = switch (type.getAdvancedFactoryType()) {
                case AdvancedFactoryType.OXIDIZING -> s -> ((InputRecipeCache.SingleItem)MekanismRecipeType.OXIDIZING.getInputCache()).containsInput(null, s);
                case AdvancedFactoryType.DISSOLVING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.DISSOLUTION.getInputCache()).containsInputA(null, s);
                case AdvancedFactoryType.PRESSURISED_REACTING -> s -> ((InputRecipeCache.ItemFluidChemical)MekanismRecipeType.REACTION.getInputCache()).containsInputA(null, s);
                case AdvancedFactoryType.LIQUIFYING -> TileEntityLiquifyingFactory::isValidInputStatic;
                default -> null;
            };
            Predicate<ChemicalStack> recipeChemicalInputPredicate = switch (type.getAdvancedFactoryType()) {
                case AdvancedFactoryType.CHEMICAL_INFUSING -> s -> ((InputRecipeCache.EitherSideChemical)MekanismRecipeType.CHEMICAL_INFUSING.getInputCache()).containsInput(null, s);
                case AdvancedFactoryType.DISSOLVING -> s -> ((InputRecipeCache.ItemChemical)MekanismRecipeType.DISSOLUTION.getInputCache()).containsInputB(null, s);
                case AdvancedFactoryType.WASHING -> s -> ((InputRecipeCache.FluidChemical)MekanismRecipeType.WASHING.getInputCache()).containsInputB(null, s);
                case AdvancedFactoryType.CRYSTALLIZING -> s -> ((InputRecipeCache.SingleChemical)MekanismRecipeType.CRYSTALLIZING.getInputCache()).containsInput(null, s);
                case AdvancedFactoryType.PRESSURISED_REACTING -> s -> ((InputRecipeCache.ItemFluidChemical)MekanismRecipeType.REACTION.getInputCache()).containsInputC(null, s);
                case AdvancedFactoryType.CENTRIFUGING -> s -> ((InputRecipeCache.SingleChemical)MekanismRecipeType.CENTRIFUGING.getInputCache()).containsInput(null, s);
                default -> null;
            };
            switch (type.getAdvancedFactoryType()) {
                case OXIDIZING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> AFChemicalTanksBuilder.builder().addOutputFactoryTank(processes, 10000L * (long)tier.processes).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> AFItemSlotsBuilder.builder().addInputFactorySlots(processes, recipeItemInputPredicate).addEnergy().build());
                    break;
                }
                case DISSOLVING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> AFChemicalTanksBuilder.builder().addBasic(10000L * (long)processes, recipeChemicalInputPredicate).addOutputFactoryTank(processes, 10000L * (long)processes).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> AFItemSlotsBuilder.builder().addInputFactorySlots(processes, recipeItemInputPredicate).addChemicalFillOrConvertSlot(0).addEnergy().build());
                    break;
                }
                case CHEMICAL_INFUSING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> AFChemicalTanksBuilder.builder().addInputFactoryTank(processes, 10000L * (long)processes, recipeChemicalInputPredicate).addOutputFactoryTank(processes, 10000L * (long)processes).addBasic(10000L * (long)processes, recipeChemicalInputPredicate).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addChemicalFillOrConvertSlot(1).addEnergy().build());
                    break;
                }
                case WASHING: {
                    holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000 * processes * processes, (IMekanismRecipeTypeProvider)MekanismRecipeType.WASHING, DoubleInputRecipeCache::containsInputA).build()).addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> AFChemicalTanksBuilder.builder().addInputFactoryTank(processes, 10000L * (long)processes, recipeChemicalInputPredicate).addOutputFactoryTank(processes, 10000L * (long)processes).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addFluidFillSlot(0).addOutput().addEnergy().build());
                    break;
                }
                case PRESSURISED_REACTING: {
                    holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000 * processes, (IMekanismRecipeTypeProvider)MekanismRecipeType.REACTION, TripleInputRecipeCache::containsInputB).build()).addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> AFChemicalTanksBuilder.builder().addBasic(10000L * (long)processes, recipeChemicalInputPredicate).addBasic(10000L * (long)processes).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeItemInputPredicate).addEnergy().build());
                    break;
                }
                case CRYSTALLIZING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> AFChemicalTanksBuilder.builder().addInputFactoryTank(tier.processes, 10000L * (long)tier.processes, recipeChemicalInputPredicate).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> AFItemSlotsBuilder.builder().addOutputFactorySlots(tier.processes).addEnergy().build());
                    break;
                }
                case CENTRIFUGING: {
                    holder.addAttachmentOnlyContainers(ContainerType.CHEMICAL, () -> AFChemicalTanksBuilder.builder().addInputFactoryTank(processes, 10000L * (long)processes, recipeChemicalInputPredicate).addOutputFactoryTank(processes, 10000L * (long)processes).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addEnergy().build());
                    break;
                }
                case LIQUIFYING: {
                    holder.addAttachmentOnlyContainers(ContainerType.FLUID, () -> FluidTanksBuilder.builder().addBasic(10000 * processes).build()).addAttachmentOnlyContainers(ContainerType.ITEM, () -> ItemSlotsBuilder.builder().addBasicFactorySlots(processes, recipeItemInputPredicate).addEnergy().build());
                }
            }
        });
        return factory;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> BlockRegistryObject<BLOCK, ITEM> registerTieredBlock(ITier tier, String suffix, Supplier<? extends BLOCK> blockSupplier, BiFunction<BLOCK, Item.Properties, ITEM> itemCreator) {
        return AF_BLOCKS.register(tier.getBaseTier().getLowerName() + suffix, blockSupplier, itemCreator);
    }

    public static BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory> getAdvancedFactory(@NotNull FactoryTier tier, @NotNull AdvancedFactoryType type) {
        return (BlockRegistryObject)AF_FACTORIES.get((Object)tier, (Object)type);
    }

    public static BlockRegistryObject<BlockAdvancedFactoryMachine.BlockAdvancedFactory<?>, ItemBlockAdvancedFactory>[] getAdvancedFactoryBlocks() {
        return AF_FACTORIES.values().toArray(new BlockRegistryObject[0]);
    }

    static {
        for (FactoryTier tier : MoreMachineUtils.getFactoryTier()) {
            for (AdvancedFactoryType type : MoreMachineEnumUtils.ADVANCED_FACTORY_TYPES) {
                AF_FACTORIES.put((Object)tier, (Object)type, AdvancedFactoryBlocks.registerAdvancedFactory(AdvancedFactoryBlockTypes.getAdvancedFactory(tier, type)));
            }
        }
    }
}

