/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.mekaf.common.attachments.containers.chemical;

import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.common.attachments.containers.ContainsRecipe;
import mekanism.common.attachments.containers.chemical.AttachedChemicals;
import mekanism.common.attachments.containers.chemical.ComponentBackedChemicalTank;
import mekanism.common.attachments.containers.creator.BaseContainerCreator;
import mekanism.common.attachments.containers.creator.IBasicContainerCreator;
import mekanism.common.config.MekanismConfig;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.lookup.cache.IInputRecipeCache;
import net.minecraft.world.item.crafting.RecipeInput;

public class AFChemicalTanksBuilder {
    protected final List<IBasicContainerCreator<? extends ComponentBackedChemicalTank>> tankCreators = new ArrayList<IBasicContainerCreator<? extends ComponentBackedChemicalTank>>();

    public static AFChemicalTanksBuilder builder() {
        return new AFChemicalTanksBuilder();
    }

    protected AFChemicalTanksBuilder() {
    }

    public BaseContainerCreator<AttachedChemicals, ComponentBackedChemicalTank> build() {
        return new AFBaseChemicalTankBuilder(this.tankCreators);
    }

    public <VANILLA_INPUT extends RecipeInput, RECIPE extends MekanismRecipe<VANILLA_INPUT>, INPUT_CACHE extends IInputRecipeCache> AFChemicalTanksBuilder addBasic(long capacity, IMekanismRecipeTypeProvider<VANILLA_INPUT, RECIPE, INPUT_CACHE> recipeType, ContainsRecipe<INPUT_CACHE, ChemicalStack> containsRecipe) {
        return this.addBasic(capacity, (ChemicalStack chemical) -> containsRecipe.check(recipeType.getInputCache(), null, chemical));
    }

    public AFChemicalTanksBuilder addBasic(long capacity, Predicate<ChemicalStack> isValid) {
        return this.addBasic(() -> capacity, isValid);
    }

    public AFChemicalTanksBuilder addBasic(LongSupplier capacity, Predicate<ChemicalStack> isValid) {
        return this.addTank((IBasicContainerCreator<? extends ComponentBackedChemicalTank>)((IBasicContainerCreator)(type, attachedTo, containerIndex) -> new ComponentBackedChemicalTank(attachedTo, containerIndex, ConstantPredicates.manualOnly(), ConstantPredicates.alwaysTrueBi(), isValid, (LongSupplier)MekanismConfig.general.chemicalItemFillRate, capacity, null)));
    }

    public AFChemicalTanksBuilder addBasic(long capacity) {
        return this.addBasic(() -> capacity);
    }

    public AFChemicalTanksBuilder addBasic(LongSupplier capacity) {
        return this.addTank((IBasicContainerCreator<? extends ComponentBackedChemicalTank>)((IBasicContainerCreator)(type, attachedTo, containerIndex) -> new ComponentBackedChemicalTank(attachedTo, containerIndex, ConstantPredicates.manualOnly(), ConstantPredicates.alwaysTrueBi(), ConstantPredicates.alwaysTrue(), (LongSupplier)MekanismConfig.general.chemicalItemFillRate, capacity, null)));
    }

    public AFChemicalTanksBuilder addOutputFactoryTank(int process, long capacity) {
        for (int i = 0; i < process; ++i) {
            this.addBasic(capacity);
        }
        return this;
    }

    public AFChemicalTanksBuilder addInputFactoryTank(int process, long capacity, Predicate<ChemicalStack> recipeInputPredicate) {
        IBasicContainerCreator inputTankCreator = (type, attachedTo, containerIndex) -> new ComponentBackedChemicalTank(attachedTo, containerIndex, ConstantPredicates.manualOnly(), ConstantPredicates.alwaysTrueBi(), recipeInputPredicate, (LongSupplier)MekanismConfig.general.chemicalItemFillRate, () -> capacity, null);
        for (int i = 0; i < process; ++i) {
            this.addTank((IBasicContainerCreator<? extends ComponentBackedChemicalTank>)inputTankCreator);
        }
        return this;
    }

    public AFChemicalTanksBuilder addInternalStorage(LongSupplier rate, LongSupplier capacity, Predicate<ChemicalStack> isValid) {
        return this.addTank((IBasicContainerCreator<? extends ComponentBackedChemicalTank>)((IBasicContainerCreator)(type, attachedTo, containerIndex) -> new ComponentBackedChemicalTank(attachedTo, containerIndex, ConstantPredicates.notExternal(), ConstantPredicates.alwaysTrueBi(), isValid, rate, capacity, null)));
    }

    public AFChemicalTanksBuilder addTank(IBasicContainerCreator<? extends ComponentBackedChemicalTank> tank) {
        this.tankCreators.add(tank);
        return this;
    }

    private static class AFBaseChemicalTankBuilder
    extends BaseContainerCreator<AttachedChemicals, ComponentBackedChemicalTank> {
        public AFBaseChemicalTankBuilder(List<IBasicContainerCreator<? extends ComponentBackedChemicalTank>> creators) {
            super(creators);
        }

        public AttachedChemicals initStorage(int containers) {
            return AttachedChemicals.create((int)containers);
        }
    }
}

