/*
 * Decompiled with CFR 0.152.
 */
package com.jerry.datagen;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.InMemoryCommentedFormat;
import com.electronwill.nightconfig.core.concurrent.SynchronizedConfig;
import com.jerry.datagen.common.loot.MoreMachineLootProvider;
import com.jerry.datagen.common.recipe.imp.MoreMachineRecipeProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import mekanism.common.lib.FieldReflectionHelper;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.DeferredWorkQueue;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ConfigTracker;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.InterModEnqueueEvent;
import net.neoforged.fml.event.lifecycle.InterModProcessEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="mekmm")
public class MekmmDataGenerator {
    private static final FieldReflectionHelper<ConfigTracker, EnumMap<ModConfig.Type, Set<ModConfig>>> CONFIG_SETS;
    private static final Constructor<?> LOADED_CONFIG;
    private static final Method SET_CONFIG;

    private MekmmDataGenerator() {
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        MekmmDataGenerator.bootstrapConfigs("mekanism");
        MekmmDataGenerator.bootstrapConfigs("mekmm");
        MekmmDataGenerator.bootstrapIMC();
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new MoreMachineLootProvider(output, lookupProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new MoreMachineRecipeProvider(output, lookupProvider, existingFileHelper));
    }

    public static void bootstrapConfigs(String modid) {
        for (Set configs : ((EnumMap)CONFIG_SETS.getValue((Object)ConfigTracker.INSTANCE)).values()) {
            for (ModConfig config : configs) {
                if (!config.getModId().equals(modid)) continue;
                SynchronizedConfig commentedConfig = new SynchronizedConfig((ConfigFormat)InMemoryCommentedFormat.defaultInstance(), LinkedHashMap::new);
                config.getSpec().correct((CommentedConfig)commentedConfig);
                try {
                    SET_CONFIG.invoke((Object)config, LOADED_CONFIG.newInstance(commentedConfig, null, config), ModConfigEvent.Loading::new);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static void bootstrapIMC() {
        ArrayList<ModContainer> mods = new ArrayList<ModContainer>();
        DeferredWorkQueue enqueueIMC = new DeferredWorkQueue("IMC Bootstrap: Enqueue IMC");
        for (ModContainer mod : ModList.get().getSortedMods()) {
            if (!mod.getModId().startsWith("mekanism") && !mod.getModId().startsWith("mekmm")) continue;
            mods.add(mod);
            Objects.requireNonNull(mod.getEventBus()).post((Event)new InterModEnqueueEvent(mod, enqueueIMC));
        }
        enqueueIMC.runTasks();
        DeferredWorkQueue processIMC = new DeferredWorkQueue("IMC Bootstrap: Process IMC");
        for (ModContainer mod : mods) {
            Objects.requireNonNull(mod.getEventBus()).post((Event)new InterModProcessEvent(mod, processIMC));
        }
        processIMC.runTasks();
    }

    static {
        Class<?> loadedConfig;
        CONFIG_SETS = new FieldReflectionHelper(ConfigTracker.class, "configSets", () -> new EnumMap(ModConfig.Type.class));
        try {
            loadedConfig = Class.forName("net.neoforged.fml.config.LoadedConfig");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        LOADED_CONFIG = ObfuscationReflectionHelper.findConstructor(loadedConfig, (Class[])new Class[]{CommentedConfig.class, Path.class, ModConfig.class});
        SET_CONFIG = ObfuscationReflectionHelper.findMethod(ModConfig.class, (String)"setConfig", (Class[])new Class[]{loadedConfig, Function.class});
    }
}

