/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.datagen;

import com.glodblock.github.extendedae.api.ISpecialDrop;
import com.glodblock.github.extendedae.common.EAERegistryHandler;
import com.glodblock.github.extendedae.common.EAESingletons;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class EAELootTableProvider
extends LootTableProvider {
    public EAELootTableProvider(PackOutput p, CompletableFuture<HolderLookup.Provider> provider) {
        super(p, Collections.emptySet(), Collections.singletonList(new LootTableProvider.SubProviderEntry(SubProvider::new, LootContextParamSets.BLOCK)), provider);
    }

    public static class SubProvider
    extends BlockLootSubProvider {
        protected SubProvider(HolderLookup.Provider provider) {
            super(Collections.emptySet(), FeatureFlagSet.of(), provider);
        }

        protected void generate() {
            for (Block block : EAERegistryHandler.INSTANCE.getBlocks()) {
                if (block instanceof ISpecialDrop) continue;
                this.add(block, this.createSingleItemTable((ItemLike)block));
            }
            this.add((Block)EAESingletons.ENTRO_BUD_SMALL, this.createSingleItemTableWithSilkTouch((Block)EAESingletons.ENTRO_BUD_SMALL, (ItemLike)EAESingletons.ENTRO_SHARD));
            this.add((Block)EAESingletons.ENTRO_BUD_MEDIUM, this.createSingleItemTableWithSilkTouch((Block)EAESingletons.ENTRO_BUD_MEDIUM, (ItemLike)EAESingletons.ENTRO_SHARD));
            this.add((Block)EAESingletons.ENTRO_BUD_LARGE, this.createSingleItemTableWithSilkTouch((Block)EAESingletons.ENTRO_BUD_LARGE, (ItemLike)EAESingletons.ENTRO_SHARD));
            this.add((Block)EAESingletons.ENTRO_CLUSTER, this.createSilkTouchDispatchTable((Block)EAESingletons.ENTRO_CLUSTER, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)EAESingletons.ENTRO_CRYSTAL).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)1.0f))).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount(this.getEnchantment((ResourceKey<Enchantment>)Enchantments.FORTUNE))).apply((LootItemFunction.Builder)ApplyExplosionDecay.explosionDecay())));
            this.add((Block)EAESingletons.FULLY_ENTROIZED_FLUIX_BUDDING, this.createSingleItemTable((ItemLike)EAESingletons.ENTRO_DUST));
            this.add((Block)EAESingletons.MOSTLY_ENTROIZED_FLUIX_BUDDING, this.createSingleItemTable((ItemLike)EAESingletons.ENTRO_DUST));
            this.add((Block)EAESingletons.HALF_ENTROIZED_FLUIX_BUDDING, this.createSingleItemTable((ItemLike)EAESingletons.ENTRO_DUST));
            this.add((Block)EAESingletons.HARDLY_ENTROIZED_FLUIX_BUDDING, this.createSingleItemTable((ItemLike)EAESingletons.ENTRO_DUST));
        }

        public void generate(@NotNull BiConsumer<ResourceKey<LootTable>, LootTable.Builder> bi) {
            this.generate();
            for (Map.Entry e : this.map.entrySet()) {
                bi.accept((ResourceKey<LootTable>)((ResourceKey)e.getKey()), (LootTable.Builder)e.getValue());
            }
        }

        protected final Holder<Enchantment> getEnchantment(ResourceKey<Enchantment> key) {
            return this.registries.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(key);
        }
    }
}

