/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.extendedae.common.parts;

import appeng.api.behaviors.PickupStrategy;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigManagerBuilder;
import appeng.core.AEConfig;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.helpers.IConfigInvHost;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuHostLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModelData;
import appeng.parts.automation.PlaneModels;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.ConfigInventory;
import appeng.util.SettingsFrom;
import appeng.util.prioritylist.IPartitionList;
import com.glodblock.github.extendedae.ExtendedAE;
import com.glodblock.github.extendedae.container.ContainerSmartAnnihilationPlane;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;

public class PartSmartAnnihilationPlane
extends UpgradeablePart
implements IGridTickable,
IConfigInvHost {
    public static final List<ResourceLocation> MODELS = List.of(ExtendedAE.id("part/smart_annihilation_plane"), ExtendedAE.id("part/smart_annihilation_plane_on"));
    @PartModels
    public static final IPartModel MODELS_OFF = new PartModel(new ResourceLocation[]{MODELS.get(0), PlaneModels.MODEL_CHASSIS_OFF});
    @PartModels
    public static final IPartModel MODELS_ON = new PartModel(new ResourceLocation[]{MODELS.get(0), PlaneModels.MODEL_CHASSIS_ON});
    @PartModels
    public static final IPartModel MODELS_HAS_CHANNEL = new PartModel(new ResourceLocation[]{MODELS.get(1), PlaneModels.MODEL_CHASSIS_HAS_CHANNEL});
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper((AEBasePart)this);
    private final ConfigInventory config;
    @Nullable
    private List<PickupStrategy> pickupStrategies;
    private ItemEnchantments enchantments = ItemEnchantments.EMPTY;
    private int continuousGenerationTicks;
    private ContinuousGeneration continuousGeneration;
    private final IActionSource actionSource = new MachineSource((IActionHost)this);
    private IPartitionList filter;
    private IncludeExclude listMode = IncludeExclude.WHITELIST;

    public PartSmartAnnihilationPlane(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IGridTickable.class, (IGridNodeService)this);
        this.config = ConfigInventory.configTypes((int)63).supportedTypes(AEKeyType.items(), new AEKeyType[]{AEKeyType.fluids()}).changeListener(this::updateFilter).build();
    }

    private void updateFilter() {
        boolean isFuzzy = this.getUpgrades().isInstalled((ItemLike)AEItems.FUZZY_CARD);
        IPartitionList.Builder builder = IPartitionList.builder();
        builder.addAll((Iterable)this.config.keySet());
        if (isFuzzy) {
            builder.fuzzyMode((FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE));
        }
        this.filter = builder.build();
        this.listMode = this.getUpgrades().isInstalled((ItemLike)AEItems.INVERTER_CARD) ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST;
        this.refresh();
    }

    public void upgradesChanged() {
        this.updateFilter();
    }

    private IPartitionList getFilter() {
        if (this.filter == null) {
            this.updateFilter();
        }
        return this.filter;
    }

    protected void registerSettings(IConfigManagerBuilder builder) {
        super.registerSettings(builder);
        builder.registerSetting(Settings.FUZZY_MODE, (Enum)FuzzyMode.IGNORE_ALL);
    }

    protected int getUpgradeSlots() {
        return 5;
    }

    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.getHost().markForSave();
    }

    public void addToWorld() {
        super.addToWorld();
        BlockEntity host = this.getBlockEntity();
        int buildHeight = host.getLevel().getMaxBuildHeight();
        this.continuousGenerationTicks = 0;
        if (AEConfig.instance().isAnnihilationPlaneSkyDustGenerationEnabled() && host.getBlockPos().getY() + 1 >= buildHeight && this.getSide() == Direction.UP) {
            this.continuousGeneration = new ContinuousGeneration((AEKey)AEItemKey.of((ItemLike)AEItems.SKY_DUST), 1L, 200);
        }
    }

    public void readFromNBT(CompoundTag data, HolderLookup.Provider registries) {
        super.readFromNBT(data, registries);
        this.config.readFromChildTag(data, "config", registries);
        CompoundTag enchantmentsTag = data.getCompound("enchantments");
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.enchantments = (ItemEnchantments)((Pair)ItemEnchantments.CODEC.decode((DynamicOps)ops, (Object)enchantmentsTag).ifError(err -> ExtendedAE.LOGGER.warn("Failed to load enchantments for part {}: {}", (Object)this, (Object)err.message())).getOrThrow()).getFirst();
    }

    public void writeToNBT(CompoundTag data, HolderLookup.Provider registries) {
        CompoundTag compoundTag;
        super.writeToNBT(data, registries);
        this.config.writeToChildTag(data, "config", registries);
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        Tag enchantmentsTag = (Tag)ItemEnchantments.CODEC.encodeStart((DynamicOps)ops, (Object)this.enchantments).getOrThrow();
        if (enchantmentsTag instanceof CompoundTag && !(compoundTag = (CompoundTag)enchantmentsTag).isEmpty()) {
            data.put("enchantments", enchantmentsTag);
        }
    }

    public void importSettings(SettingsFrom mode, DataComponentMap data, @Nullable Player player) {
        super.importSettings(mode, data, player);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.enchantments = (ItemEnchantments)data.get(DataComponents.ENCHANTMENTS);
        }
        this.pickupStrategies = null;
    }

    public void exportSettings(SettingsFrom mode, DataComponentMap.Builder data) {
        super.exportSettings(mode, data);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            data.set(DataComponents.ENCHANTMENTS, (Object)this.enchantments);
        }
    }

    public boolean onUseWithoutItem(Player player, Vec3 pos) {
        if (!this.isClientSide()) {
            this.openConfigMenu(player);
        }
        return true;
    }

    private void openConfigMenu(Player player) {
        MenuOpener.open(this.getMenuType(), (Player)player, (MenuHostLocator)MenuLocators.forPart((AEBasePart)this));
    }

    protected MenuType<?> getMenuType() {
        return ContainerSmartAnnihilationPlane.TYPE;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane, false);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (!this.isActive()) {
            return TickRateModulation.SLEEP;
        }
        IGrid grid = node.getGrid();
        if (this.continuousGeneration != null) {
            this.continuousGenerationTicks += ticksSinceLastCall;
            if (this.continuousGenerationTicks >= this.continuousGeneration.ticks) {
                long amount = this.continuousGenerationTicks / this.continuousGeneration.ticks;
                this.insertIntoGrid(this.continuousGeneration.what, amount, Actionable.MODULATE);
                this.continuousGenerationTicks -= (int)(amount * (long)this.continuousGeneration.ticks);
            }
            return TickRateModulation.IDLE;
        }
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            pickupStrategy.reset();
        }
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            PickupStrategy.Result pickupResult = pickupStrategy.tryPickup((IEnergySource)grid.getEnergyService(), this::insertIntoGrid);
            if (pickupResult == PickupStrategy.Result.PICKED_UP) {
                return TickRateModulation.URGENT;
            }
            if (pickupResult != PickupStrategy.Result.CANT_STORE) continue;
            return TickRateModulation.IDLE;
        }
        return TickRateModulation.SLEEP;
    }

    private long insertIntoGrid(AEKey what, long amount, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return 0L;
        }
        if (this.getFilter().matchesFilter(what, this.listMode)) {
            return StorageHelper.poweredInsert((IEnergySource)grid.getEnergyService(), (MEStorage)grid.getStorageService().getInventory(), (AEKey)what, (long)amount, (IActionSource)this.actionSource, (Actionable)mode);
        }
        return 0L;
    }

    public void getBoxes(IPartCollisionHelper bch) {
        if (bch.isBBCollision()) {
            bch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 15.5);
            return;
        }
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (pos.relative(this.getSide()).equals((Object)neighbor) && !this.isClientSide()) {
            this.refresh();
        }
    }

    public void onUpdateShape(Direction side) {
        Direction ourSide = this.getSide();
        if (side.equals((Object)ourSide)) {
            if (!this.isClientSide()) {
                this.refresh();
            }
        } else if (ourSide.getAxis() != side.getAxis()) {
            this.connectionHelper.updateConnections();
        }
    }

    public void onEntityCollision(Entity entity) {
        boolean capture;
        if (!entity.isAlive() || this.isClientSide() || !this.getMainNode().isActive()) {
            return;
        }
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        PickupStrategy strategy = null;
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            if (!pickupStrategy.canPickUpEntity(entity)) continue;
            strategy = pickupStrategy;
            break;
        }
        if (strategy == null) {
            return;
        }
        BlockPos pos = this.getHost().getBlockEntity().getBlockPos();
        int planePosX = pos.getX();
        int planePosY = pos.getY();
        int planePosZ = pos.getZ();
        double posYMiddle = (entity.getBoundingBox().minY + entity.getBoundingBox().maxY) / 2.0;
        double entityPosX = entity.getX();
        double entityPosY = entity.getY();
        double entityPosZ = entity.getZ();
        boolean captureX = entityPosX > (double)planePosX && entityPosX < (double)(planePosX + 1);
        boolean captureY = posYMiddle > (double)planePosY && posYMiddle < (double)(planePosY + 1);
        boolean captureZ = entityPosZ > (double)planePosZ && entityPosZ < (double)(planePosZ + 1);
        switch (this.getSide()) {
            default: {
                throw new MatchException(null, null);
            }
            case DOWN: {
                boolean bl;
                if (captureX && captureZ && entityPosY < (double)planePosY + 0.1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case UP: {
                boolean bl;
                if (captureX && captureZ && entityPosY > (double)planePosY + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SOUTH: {
                boolean bl;
                if (captureX && captureY && entityPosZ > (double)planePosZ + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case NORTH: {
                boolean bl;
                if (captureX && captureY && entityPosZ < (double)planePosZ + 0.1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case EAST: {
                boolean bl;
                if (captureZ && captureY && entityPosX > (double)planePosX + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WEST: {
                boolean bl = capture = captureZ && captureY && entityPosX < (double)planePosX + 0.1;
            }
        }
        if (capture && !strategy.pickUpEntity((IEnergySource)grid.getEnergyService(), this::insertIntoGrid, entity)) {
            this.getMainNode().ifPresent((g, n) -> g.getTickManager().alertDevice(n));
        }
    }

    protected List<PickupStrategy> getPickupStrategies() {
        if (this.pickupStrategies == null) {
            IGridNode node = this.getMainNode().getNode();
            if (node == null) {
                return List.of();
            }
            BlockEntity self = this.getHost().getBlockEntity();
            BlockPos pos = self.getBlockPos().relative(this.getSide());
            Direction side = this.getSide().getOpposite();
            UUID owner = node.getOwningPlayerProfileId();
            this.pickupStrategies = StackWorldBehaviors.createPickupStrategies((ServerLevel)((ServerLevel)self.getLevel()), (BlockPos)pos, (Direction)side, (BlockEntity)self, (ItemEnchantments)this.enchantments, (UUID)owner);
        }
        return this.pickupStrategies;
    }

    private void refresh() {
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            pickupStrategy.reset();
        }
        this.getMainNode().ifPresent((g, n) -> g.getTickManager().alertDevice(n));
    }

    public ConfigInventory getConfig() {
        return this.config;
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    public ModelData getModelData() {
        return ModelData.builder().with(PlaneModelData.CONNECTIONS, (Object)this.getConnections()).build();
    }

    private record ContinuousGeneration(AEKey what, long amount, int ticks) {
    }
}

