/*
 * Decompiled with CFR 0.152.
 */
package com.wampi.aq.datagen;

import com.wampi.aq.datagen.AQBlockLootTableProvider;
import com.wampi.aq.datagen.AQBlockStateProvider;
import com.wampi.aq.datagen.AQBlockTagProvider;
import com.wampi.aq.datagen.AQDataMapProvider;
import com.wampi.aq.datagen.AQItemModelProvider;
import com.wampi.aq.datagen.AQItemTagProvider;
import com.wampi.aq.datagen.AQRecipeProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="aq", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(AQBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new AQRecipeProvider(packOutput, lookupProvider));
        AQBlockTagProvider blockTagsProvider = new AQBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new AQItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AQDataMapProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (DataProvider)new AQItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new AQBlockStateProvider(packOutput, existingFileHelper));
    }
}

