/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import me.desht.pneumaticcraft.api.item.ILaunchBehaviour;
import me.desht.pneumaticcraft.common.config.ConfigHelper;
import me.desht.pneumaticcraft.common.entity.projectile.MicromissileEntity;
import me.desht.pneumaticcraft.common.entity.projectile.TumblingBlockEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketSetEntityMotion;
import me.desht.pneumaticcraft.common.network.PacketSpawnParticle;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.registry.ModItems;
import me.desht.pneumaticcraft.common.registry.ModSounds;
import me.desht.pneumaticcraft.mixin.accessors.BoatItemAccess;
import me.desht.pneumaticcraft.mixin.accessors.MinecartItemAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemLaunching {
    private static final List<ILaunchBehaviour> behaviours = new CopyOnWriteArrayList<ILaunchBehaviour>();

    public static void launchEntity(Entity launchedEntity, Vec3 initialPos, Vec3 velocity, boolean doSpawn) {
        Level world = launchedEntity.getCommandSenderWorld();
        if (launchedEntity.getVehicle() != null) {
            launchedEntity.stopRiding();
        }
        BlockPos trackPos = BlockPos.containing((Position)initialPos);
        if (launchedEntity instanceof Boat) {
            launchedEntity.setPos(initialPos.x, initialPos.y + 1.0, initialPos.z);
        } else {
            launchedEntity.setPos(initialPos.x, initialPos.y, initialPos.z);
        }
        NetworkHandler.sendToAllTracking(PacketSetEntityMotion.create(launchedEntity, velocity), world, trackPos);
        if (launchedEntity instanceof AbstractHurtingProjectile) {
            AbstractHurtingProjectile hurtingProjectile = (AbstractHurtingProjectile)launchedEntity;
            hurtingProjectile.accelerationPower = 0.1;
        }
        launchedEntity.setDeltaMovement(velocity);
        launchedEntity.setOnGround(false);
        launchedEntity.horizontalCollision = false;
        launchedEntity.verticalCollision = false;
        if (doSpawn && !world.isClientSide) {
            world.addFreshEntity(launchedEntity);
        }
        for (int i = 0; i < 5; ++i) {
            double velX = velocity.x * 0.4 + (world.random.nextGaussian() - 0.5) * 0.05;
            double velY = velocity.y * 0.4 + (world.random.nextGaussian() - 0.5) * 0.05;
            double velZ = velocity.z * 0.4 + (world.random.nextGaussian() - 0.5) * 0.05;
            NetworkHandler.sendToAllTracking(PacketSpawnParticle.oneParticle(AirParticleData.DENSE, initialPos.toVector3f(), new Vec3(velX, velY, velZ).toVector3f()), world, trackPos);
        }
        world.playSound(null, initialPos.x, initialPos.y, initialPos.z, (SoundEvent)ModSounds.AIR_CANNON.get(), SoundSource.BLOCKS, 1.0f, world.random.nextFloat() / 4.0f + 0.75f);
    }

    public static Entity getEntityToLaunch(Level world, ItemStack stack, ServerPlayer player, boolean dispenserLike, boolean fallingBlocks) {
        Item item = stack.getItem();
        if (dispenserLike) {
            for (ILaunchBehaviour behaviour : behaviours) {
                Entity e = behaviour.getEntityToLaunch(stack, player);
                if (e == null) continue;
                return e;
            }
        }
        if (fallingBlocks && item instanceof BlockItem) {
            return new TumblingBlockEntity(world, (LivingEntity)player, 0.0, 0.0, 0.0, stack);
        }
        ItemEntity e = new ItemEntity(world, 0.0, 0.0, 0.0, stack);
        e.setPickUpDelay(20);
        return e;
    }

    public static void registerBehaviour(ILaunchBehaviour behaviour) {
        behaviours.add(behaviour);
    }

    public static void registerDefaultBehaviours() {
        ItemLaunching.registerBehaviour((stack, player) -> {
            Item item = stack.getItem();
            ServerLevel level = (ServerLevel)player.level();
            float playerYaw = player.getRotationVector().y;
            float playerPitch = player.getRotationVector().x;
            if (item == Items.ARMOR_STAND) {
                ArmorStand armorStand = new ArmorStand((Level)level, 0.0, 0.0, 0.0);
                armorStand.setYRot(playerYaw);
                return armorStand;
            }
            if (item instanceof ArrowItem) {
                ArrowItem arrowItem = (ArrowItem)item;
                return arrowItem.createArrow((Level)level, stack, (LivingEntity)player, null);
            }
            if (item instanceof BoatItem) {
                BoatItem boatItem = (BoatItem)item;
                EntityHitResult dummyHitResult = new EntityHitResult((Entity)player, new Vec3(0.0, 0.0, 0.0));
                Boat boat = ((BoatItemAccess)boatItem).invokeGetBoat((Level)level, (HitResult)dummyHitResult, stack, (Player)player);
                boat.setYRot(playerYaw);
                return boat;
            }
            if (item == Items.EXPERIENCE_BOTTLE) {
                return new ThrownExperienceBottle((Level)level, (LivingEntity)player);
            }
            if (item instanceof PotionItem) {
                ThrownPotion potionEntity = new ThrownPotion((Level)level, (LivingEntity)player);
                potionEntity.setItem(stack);
                return potionEntity;
            }
            if (item == Blocks.TNT.asItem()) {
                PrimedTnt tnt = new PrimedTnt((Level)level, 0.0, 0.0, 0.0, (LivingEntity)player);
                tnt.setFuse(80);
                return tnt;
            }
            if (item == Items.EGG) {
                return new ThrownEgg((Level)level, (LivingEntity)player);
            }
            if (item == Items.FIRE_CHARGE) {
                SmallFireball e = new SmallFireball((Level)level, (LivingEntity)player, Vec3.ZERO);
                e.setItem(stack);
                return e;
            }
            if (item == Items.SNOWBALL) {
                return new Snowball((Level)level, (LivingEntity)player);
            }
            if (item instanceof SpawnEggItem) {
                SpawnEggItem egg = (SpawnEggItem)item;
                EntityType type = egg.getType(stack);
                Entity e = type.spawn(level, stack, (Player)player, player.blockPosition(), MobSpawnType.SPAWN_EGG, false, false);
                if (e instanceof LivingEntity && stack.has(DataComponents.CUSTOM_NAME)) {
                    e.setCustomName(stack.getHoverName());
                }
                return e;
            }
            if (item instanceof MinecartItem) {
                MinecartItem mi = (MinecartItem)item;
                AbstractMinecart minecart = Minecart.createMinecart((ServerLevel)level, (double)0.0, (double)0.0, (double)0.0, (AbstractMinecart.Type)((MinecartItemAccess)mi).getType(), (ItemStack)stack, (Player)player);
                minecart.setYRot(playerYaw);
                return minecart;
            }
            if (item == Items.FIREWORK_ROCKET) {
                return new FireworkRocketEntity((Level)level, stack, 0.0, 0.0, 0.0, true);
            }
            if (item == Items.TRIDENT) {
                stack.hurtAndBreak(1, (ServerLevel)player.level(), player, i -> {});
                return new ThrownTrident((Level)level, (LivingEntity)player, stack);
            }
            if (item == ModItems.MICROMISSILES.get()) {
                stack.hurtAndBreak(1, (ServerLevel)player.level(), player, i -> {});
                MicromissileEntity micromissile = new MicromissileEntity((Level)level, (LivingEntity)player, stack);
                micromissile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.33333334f, 0.0f);
                player.getCooldowns().addCooldown(stack.getItem(), (Integer)ConfigHelper.common().micromissiles.launchCooldown.get() / 3);
                return micromissile;
            }
            return null;
        });
    }
}

