/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.block.entity.IGUIButtonSensitive;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGuiButton(String tag, boolean shiftHeld) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketGuiButton> TYPE = new CustomPacketPayload.Type(PneumaticRegistry.RL("gui_button"));
    public static final StreamCodec<FriendlyByteBuf, PacketGuiButton> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PacketGuiButton::tag, (StreamCodec)ByteBufCodecs.BOOL, PacketGuiButton::shiftHeld, PacketGuiButton::new);

    public PacketGuiButton(String tag) {
        this(tag, ClientUtils.hasShiftDown());
    }

    public CustomPacketPayload.Type<PacketGuiButton> type() {
        return TYPE;
    }

    public static void handle(PacketGuiButton message, IPayloadContext ctx) {
        Player player = ctx.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            player = sp.containerMenu;
            if (player instanceof IGUIButtonSensitive) {
                IGUIButtonSensitive gbs = (IGUIButtonSensitive)player;
                gbs.handleGUIButtonPress(message.tag, message.shiftHeld, sp);
            }
        }
    }
}

