/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity.semiblock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.client.model.PNCModelLayers;
import me.desht.pneumaticcraft.client.model.entity.semiblocks.ModelSpawnerAgitator;
import me.desht.pneumaticcraft.client.render.entity.semiblock.RenderSemiblockBase;
import me.desht.pneumaticcraft.common.entity.semiblock.SpawnerAgitatorEntity;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;

public class RenderSpawnerAgitator
extends RenderSemiblockBase<SpawnerAgitatorEntity> {
    private static final float BRIGHTNESS = 0.2f;
    private final ModelSpawnerAgitator model;

    public RenderSpawnerAgitator(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new ModelSpawnerAgitator(ctx.bakeLayer(PNCModelLayers.SPAWNER_AGITATOR));
    }

    public void render(SpawnerAgitatorEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        float g = 0.1f * Mth.sin((float)(((float)entity.level().getGameTime() + partialTicks) / 12.0f));
        matrixStackIn.pushPose();
        matrixStackIn.translate(0.0, 1.5, 0.0);
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(180.0f));
        if (entity.getTimeSinceHit() > 0) {
            this.wobble(entity, partialTicks, matrixStackIn);
        }
        VertexConsumer builder = bufferIn.getBuffer(RenderType.entityCutout((ResourceLocation)this.getTextureLocation(entity)));
        int color = FastColor.ARGB32.color((int)255, (int)51, (int)((int)(255.0f * (0.8f + g))), (int)51);
        this.model.renderToBuffer(matrixStackIn, builder, packedLightIn, OverlayTexture.pack((float)0.0f, (boolean)false), color);
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(SpawnerAgitatorEntity entity) {
        return Textures.MODEL_SPAWNER_AGITATOR;
    }
}

