/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import me.desht.pneumaticcraft.common.entity.projectile.TumblingBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class RenderTumblingBlock
extends EntityRenderer<TumblingBlockEntity> {
    public RenderTumblingBlock(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(TumblingBlockEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        Level world;
        ItemStack stack = entity.getStack();
        if (stack.isEmpty() || !(stack.getItem() instanceof BlockItem)) {
            return;
        }
        Block block = ((BlockItem)stack.getItem()).getBlock();
        BlockState state = block.defaultBlockState();
        if (state.getRenderShape() == RenderShape.MODEL && state != (world = entity.getCommandSenderWorld()).getBlockState(entity.blockPosition()) && state.getRenderShape() != RenderShape.INVISIBLE) {
            matrixStackIn.pushPose();
            if (entity.tumbleVec != null) {
                matrixStackIn.translate(0.0, 0.5, 0.0);
                float angle = ((float)entity.tickCount + partialTicks) * 18.0f;
                matrixStackIn.mulPose(Axis.of((Vector3f)entity.tumbleVec).rotationDegrees(angle));
                matrixStackIn.translate(-0.5, -0.5, -0.5);
            }
            BlockPos blockpos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
            BlockRenderDispatcher renderer = Minecraft.getInstance().getBlockRenderer();
            BakedModel blockModel = renderer.getBlockModel(state);
            for (RenderType type : blockModel.getRenderTypes(state, world.getRandom(), ModelData.EMPTY)) {
                renderer.getModelRenderer().tesselateBlock((BlockAndTintGetter)world, blockModel, state, blockpos, matrixStackIn, bufferIn.getBuffer(type), false, world.getRandom(), state.getSeed(entity.getOrigin()), OverlayTexture.NO_OVERLAY, ModelData.EMPTY, type);
            }
            matrixStackIn.popPose();
        }
    }

    public ResourceLocation getTextureLocation(TumblingBlockEntity entity) {
        return null;
    }
}

