/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.client.util.ProgressingLine;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import net.minecraft.client.gui.GuiGraphics;

public class HackSimulationRenderer {
    private final int baseX;
    private final int baseY;
    private final int nodeSpacing;

    public HackSimulationRenderer(int baseX, int baseY, int nodeSpacing) {
        this.baseX = baseX;
        this.baseY = baseY;
        this.nodeSpacing = nodeSpacing;
    }

    public void render(GuiGraphics graphics, HackSimulation hackSimulation, int color) {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        for (HackSimulation.ConnectionEntry entry : hackSimulation.allConnections) {
            GuiUtils.renderProgressingLine2d(graphics, this.makeProgressingLine(entry), color, 3.0f);
        }
        RenderSystem.disableBlend();
    }

    private ProgressingLine makeProgressingLine(HackSimulation.ConnectionEntry entry) {
        int xOff = 0;
        int yOff = 0;
        int delta = entry.from() - entry.to();
        if (delta == 5) {
            xOff = 1;
        } else if (delta == -5) {
            xOff = -1;
        } else {
            yOff = delta < 0 ? -1 : 1;
        }
        int startX = this.baseX + xOff + entry.from() % 5 * this.nodeSpacing;
        int startY = this.baseY + yOff + entry.from() / 5 * this.nodeSpacing;
        int endX = this.baseX + xOff + entry.to() % 5 * this.nodeSpacing;
        int endY = this.baseY + yOff + entry.to() / 5 * this.nodeSpacing;
        return new ProgressingLine(startX, startY, endX, endY).setProgress(entry.progress());
    }
}

