/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.InventoryTrackEvent;
import me.desht.pneumaticcraft.client.pneumatic_armor.block_tracker.TrackerBlacklistManager;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.mixin.accessors.BaseContainerBlockEntityAccess;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.LockCode;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;

public class BlockTrackEntryInventory
implements IBlockTrackEntry {
    public static final ResourceLocation ID = PneumaticRegistry.RL("block_tracker.module.inventories");

    @Override
    public boolean shouldTrackWithThisEntry(Level world, BlockPos pos, BlockState state, BlockEntity te) {
        if (te instanceof ChestBlockEntity && state.hasProperty((Property)ChestBlock.TYPE) && state.getValue((Property)ChestBlock.TYPE) == ChestType.RIGHT) {
            return false;
        }
        return te != null && !TrackerBlacklistManager.isInventoryBlacklisted(te) && (te instanceof RandomizableContainerBlockEntity || IBlockTrackEntry.hasCapabilityOnAnyFace(te, Capabilities.ItemHandler.BLOCK)) && this.postTrackEvent(te);
    }

    private boolean postTrackEvent(BlockEntity te) {
        InventoryTrackEvent event = (InventoryTrackEvent)NeoForge.EVENT_BUS.post((Event)new InventoryTrackEvent(te));
        return !event.isCanceled();
    }

    @Override
    public List<BlockPos> getServerUpdatePositions(BlockEntity te) {
        if (te instanceof RandomizableContainerBlockEntity && !IBlockTrackEntry.hasCapabilityOnAnyFace(te, Capabilities.ItemHandler.BLOCK)) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (te instanceof ChestBlockEntity && te.getBlockState().getValue((Property)ChestBlock.TYPE) == ChestType.LEFT) {
            Direction dir = ChestBlock.getConnectedDirection((BlockState)te.getBlockState());
            builder.add((Object)te.getBlockPos().relative(dir));
        }
        builder.add((Object)te.getBlockPos());
        return builder.build();
    }

    @Override
    public int spamThreshold() {
        return 16;
    }

    @Override
    public void addInformation(Level world, BlockPos pos, BlockEntity te, Direction face, List<Component> infoList) {
        if (!BlockTrackEntryInventory.canUnlock(te)) {
            infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.locked", new Object[0]).withStyle(ChatFormatting.ITALIC));
            return;
        }
        try {
            IOHelper.getInventoryForBlock(te, face).ifPresent(inventory -> {
                ArrayList<ItemStack> inventoryStacks = new ArrayList<ItemStack>(inventory.getSlots());
                for (int i = 0; i < inventory.getSlots(); ++i) {
                    ItemStack iStack = inventory.getStackInSlot(i);
                    if (iStack.isEmpty()) continue;
                    inventoryStacks.add(iStack);
                }
                if (inventoryStacks.isEmpty()) {
                    infoList.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.misc.empty", new Object[0]).withStyle(ChatFormatting.ITALIC));
                } else {
                    PneumaticCraftUtils.summariseItemStacks(infoList, inventoryStacks);
                }
            });
        }
        catch (Throwable e) {
            TrackerBlacklistManager.addInventoryTEToBlacklist(te, e);
        }
    }

    @Override
    public ResourceLocation getEntryID() {
        return ID;
    }

    private static boolean canUnlock(BlockEntity be) {
        if (be instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity base = (BaseContainerBlockEntity)be;
            LockCode key = ((BaseContainerBlockEntityAccess)base).getLockKey();
            return key.unlocksWith(ClientUtils.getClientPlayer().getMainHandItem());
        }
        return true;
    }
}

