/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.remote;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.remote.IRemoteWidget;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftContainerScreen;
import me.desht.pneumaticcraft.client.gui.remote.RemoteClientRegistry;
import me.desht.pneumaticcraft.client.gui.remote.RemoteScreen;
import me.desht.pneumaticcraft.client.util.PointXY;
import me.desht.pneumaticcraft.common.block.entity.AbstractPneumaticCraftBlockEntity;
import me.desht.pneumaticcraft.common.inventory.RemoteMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractRemoteScreen
extends AbstractPneumaticCraftContainerScreen<RemoteMenu, AbstractPneumaticCraftBlockEntity> {
    protected final ItemStack remoteItem;
    protected final Map<AbstractWidget, IRemoteWidget> widgetMap = new LinkedHashMap<AbstractWidget, IRemoteWidget>();

    public AbstractRemoteScreen(RemoteMenu container, Inventory inv, Component displayString) {
        super(container, inv, displayString);
        this.remoteItem = inv.player.getItemInHand(container.getHand());
    }

    protected void addRemoteWidget(AbstractWidget mcWidget, IRemoteWidget remoteWidget) {
        this.widgetMap.put(mcWidget, remoteWidget);
        this.addRenderableWidget((GuiEventListener)mcWidget);
    }

    public static void handleVariableChangeIfOpen(String varName) {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof RemoteScreen) {
            RemoteScreen r = (RemoteScreen)screen;
            r.onGlobalVariableChanged(varName);
        }
    }

    static Map<AbstractWidget, IRemoteWidget> buildMinecraftWidgetList(List<IRemoteWidget> remoteWidgets, AbstractRemoteScreen screen, boolean filterWidgets) {
        LinkedHashMap<AbstractWidget, IRemoteWidget> map = new LinkedHashMap<AbstractWidget, IRemoteWidget>();
        remoteWidgets.forEach(remoteWidget -> {
            Object mcWidget = RemoteClientRegistry.INSTANCE.createMinecraftWidget(remoteWidget, screen);
            ((AbstractWidget)mcWidget).visible = !filterWidgets || remoteWidget.isEnabled((Player)Minecraft.getInstance().player);
            map.put((AbstractWidget)mcWidget, (IRemoteWidget)remoteWidget);
        });
        return map;
    }

    @Override
    protected PointXY getInvTextOffset() {
        return null;
    }

    @Override
    protected boolean shouldAddProblemTab() {
        return false;
    }

    @Override
    protected boolean shouldParseVariablesInTooltips() {
        return true;
    }
}

