/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.recipe;

import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class DiskResetRecipe
extends CustomRecipe {
    public DiskResetRecipe(CraftingBookCategory pGroup) {
        super(pGroup);
    }

    public int countDisks(CraftingInput input) {
        int found = 0;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            if (stack.getItem() instanceof DiskItem) {
                ++found;
                continue;
            }
            return -1;
        }
        return found;
    }

    public boolean matches(CraftingInput craftingInput, Level pLevel) {
        return this.countDisks(craftingInput) > 0;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        int foundDisks = this.countDisks(craftingInput);
        if (foundDisks > 0) {
            return new ItemStack((ItemLike)SFMItems.DISK_ITEM.get(), foundDisks);
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)SFMRecipeSerializers.DISK_RESET.get();
    }
}

