/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.export;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;

public class ClientExportHelper {
    private static final Object registryReaderLock = new Object();

    public static Collection<ItemStack> gatherItems() {
        assert (Minecraft.getInstance().player != null);
        assert (Minecraft.getInstance().level != null);
        CreativeModeTabs.tryRebuildTabContents((FeatureFlagSet)Minecraft.getInstance().player.connection.enabledFeatures(), (boolean)true, (HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
        return CreativeModeTabs.searchTab().getDisplayItems();
    }

    public static void dumpItems(@Nullable Player player) throws IOException {
        JsonArray jsonArray = new JsonArray();
        Collection<ItemStack> items = ClientExportHelper.gatherItems();
        for (ItemStack stack : items) {
            JsonObject jsonObject = new JsonObject();
            ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
            jsonObject.addProperty("id", id.toString());
            JsonArray tags = new JsonArray();
            SFMResourceTypes.ITEM.get().getTagsForStack(stack).map(ResourceLocation::toString).forEach(arg_0 -> ((JsonArray)tags).add(arg_0));
            jsonObject.add("tags", (JsonElement)tags);
            String tooltip = stack.getTooltipLines(player != null ? Item.TooltipContext.of((Level)player.level()) : Item.TooltipContext.EMPTY, player, (TooltipFlag)TooltipFlag.ADVANCED).stream().map(Component::getString).reduce((line1, line2) -> line1 + "\n" + line2).orElse("");
            jsonObject.addProperty("tooltip", tooltip);
            jsonArray.add((JsonElement)jsonObject);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String content = gson.toJson((JsonElement)jsonArray);
        Path gameDir = FMLPaths.GAMEDIR.get();
        Path folder = Paths.get(gameDir.toString(), "sfm");
        Files.createDirectories(folder, new FileAttribute[0]);
        File itemFile = new File(folder.toFile(), "items.json");
        try (FileOutputStream str = new FileOutputStream(itemFile);){
            str.write(content.getBytes(StandardCharsets.UTF_8));
        }
        SFM.LOGGER.info("Exported item data to {}", (Object)itemFile);
        assert (Minecraft.getInstance().player != null);
        Minecraft.getInstance().player.sendSystemMessage((Component)Component.literal((String)String.format("Exported %d items to \"%s\"", items.size(), itemFile.getAbsolutePath())));
    }
}

