/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book.entries;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.book.Book;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookEntryParent;
import com.klikli_dev.modonomicon.book.BookIcon;
import com.klikli_dev.modonomicon.book.ResolvedBookEntryParent;
import com.klikli_dev.modonomicon.book.conditions.BookAndCondition;
import com.klikli_dev.modonomicon.book.conditions.BookCondition;
import com.klikli_dev.modonomicon.book.conditions.BookEntryReadCondition;
import com.klikli_dev.modonomicon.book.conditions.BookNoneCondition;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.book.page.BookPage;
import com.klikli_dev.modonomicon.bookstate.BookUnlockStateManager;
import com.klikli_dev.modonomicon.client.gui.book.BookAddress;
import com.klikli_dev.modonomicon.client.gui.book.entry.EntryDisplayState;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.data.BookPageJsonLoader;
import com.klikli_dev.modonomicon.data.JsonLoader;
import com.klikli_dev.modonomicon.data.LoaderRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class BookEntry {
    protected final BookEntryData data;
    protected ResourceLocation id;
    protected Book book;
    protected BookCategory category;
    protected List<ResolvedBookEntryParent> parents;
    protected ResourceLocation commandToRunOnFirstReadId;
    protected BookCommand commandToRunOnFirstRead;

    public BookEntry(ResourceLocation id, BookEntryData data, ResourceLocation commandToRunOnFirstReadId) {
        this.id = id;
        this.data = data;
        this.commandToRunOnFirstReadId = commandToRunOnFirstReadId;
    }

    public int getX() {
        return this.data.x;
    }

    public int getY() {
        return this.data.y;
    }

    public abstract ResourceLocation getType();

    public abstract void openEntry(BookAddress var1);

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
    }

    public void build(Level level, BookCategory category) {
        this.book = category.getBook();
        this.category = category;
        ArrayList<ResolvedBookEntryParent> newParents = new ArrayList<ResolvedBookEntryParent>();
        for (BookEntryParent parent : this.data.parents) {
            BookEntry parentEntry = this.getBook().getEntry(parent.getEntryId());
            if (parentEntry == null) {
                BookErrorManager.get().error("Entry \"" + String.valueOf(this.getId()) + "\" has a parent that does not exist in this book: \"" + String.valueOf(parent.getEntryId()) + "\". This parent will be ignored");
                continue;
            }
            newParents.add(new ResolvedBookEntryParent(parent, parentEntry));
        }
        this.parents = newParents;
        if (this.commandToRunOnFirstReadId != null) {
            this.commandToRunOnFirstRead = this.getBook().getCommand(this.commandToRunOnFirstReadId);
            if (this.commandToRunOnFirstRead == null) {
                BookErrorManager.get().error("Command to run on first read \"" + String.valueOf(this.commandToRunOnFirstReadId) + "\" does not exist in this book. Set to null.");
                this.commandToRunOnFirstReadId = null;
            }
        }
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public EntryDisplayState getEntryDisplayState(Player player) {
        boolean isEntryUnlocked = BookUnlockStateManager.get().isUnlockedFor(player, this);
        if (isEntryUnlocked) {
            return EntryDisplayState.UNLOCKED;
        }
        if (!this.getParents().isEmpty()) {
            boolean anyParentsUnlocked = false;
            boolean allParentsUnlocked = true;
            for (BookEntryParent bookEntryParent : this.getParents()) {
                if (!BookUnlockStateManager.get().isUnlockedFor(player, bookEntryParent.getEntry())) {
                    allParentsUnlocked = false;
                    continue;
                }
                anyParentsUnlocked = true;
            }
            if (this.showWhenAnyParentUnlocked() && !anyParentsUnlocked) {
                return EntryDisplayState.HIDDEN;
            }
            if (!this.showWhenAnyParentUnlocked() && !allParentsUnlocked) {
                return EntryDisplayState.HIDDEN;
            }
        }
        return this.hideWhileLocked() ? EntryDisplayState.HIDDEN : EntryDisplayState.LOCKED;
    }

    public boolean matchesQuery(String query) {
        return this.data.name().toLowerCase().contains(query);
    }

    public int getPageNumberForAnchor(String anchor) {
        return -1;
    }

    public List<BookPage> getPages() {
        return List.of();
    }

    public List<BookPage> getUnlockedPagesFor(Player player) {
        return List.of();
    }

    public BookCommand getCommandToRunOnFirstRead() {
        return this.commandToRunOnFirstRead;
    }

    public BookCondition getCondition() {
        return this.data.condition;
    }

    public String getName() {
        return this.data.name;
    }

    public BookCategory getCategory() {
        return this.category;
    }

    public Book getBook() {
        return this.book;
    }

    public String getDescription() {
        return this.data.description;
    }

    public List<? extends BookEntryParent> getParents() {
        return this.parents == null ? this.data.parents : this.parents;
    }

    public int getEntryBackgroundUIndex() {
        return this.data.entryBackgroundUIndex;
    }

    public int getEntryBackgroundVIndex() {
        return this.data.entryBackgroundVIndex;
    }

    public boolean showWhenAnyParentUnlocked() {
        return this.data.showWhenAnyParentUnlocked;
    }

    public boolean hideWhileLocked() {
        return this.data.hideWhileLocked;
    }

    public BookIcon getIcon() {
        return this.data.icon;
    }

    public ResourceLocation getCategoryId() {
        return this.data.categoryId;
    }

    public int getSortNumber() {
        return this.data.sortNumber;
    }

    public abstract void toNetwork(RegistryFriendlyByteBuf var1);

    public record BookEntryData(ResourceLocation categoryId, List<BookEntryParent> parents, int x, int y, String name, String description, BookIcon icon, int entryBackgroundUIndex, int entryBackgroundVIndex, BookCondition condition, boolean hideWhileLocked, boolean showWhenAnyParentUnlocked, int sortNumber) {
        public static BookEntryData fromJson(ResourceLocation id, JsonObject json, boolean autoAddReadConditions, HolderLookup.Provider provider) {
            String categoryIdPath = GsonHelper.getAsString((JsonObject)json, (String)"category");
            ResourceLocation categoryId = categoryIdPath.contains(":") ? ResourceLocation.parse((String)categoryIdPath) : ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)categoryIdPath);
            int x = GsonHelper.getAsInt((JsonObject)json, (String)"x");
            int y = GsonHelper.getAsInt((JsonObject)json, (String)"y");
            ArrayList<BookEntryParent> parents = new ArrayList<BookEntryParent>();
            if (json.has("parents")) {
                for (Object parent2 : GsonHelper.getAsJsonArray((JsonObject)json, (String)"parents")) {
                    parents.add(BookEntryParent.fromJson(id, parent2.getAsJsonObject()));
                }
            }
            ArrayList<BookPage> pages = new ArrayList<BookPage>();
            if (json.has("pages")) {
                for (JsonElement pageElem : GsonHelper.getAsJsonArray((JsonObject)json, (String)"pages")) {
                    BookPage page;
                    BookErrorManager.get().setContext("Page Index: {}", pages.size());
                    JsonObject pageJson = GsonHelper.convertToJsonObject((JsonElement)pageElem, (String)"page");
                    ResourceLocation type = ResourceLocation.parse((String)GsonHelper.getAsString((JsonObject)pageJson, (String)"type"));
                    JsonLoader<? extends BookPage> loader = LoaderRegistry.getPageJsonLoader(type);
                    if (loader instanceof BookPageJsonLoader) {
                        BookPageJsonLoader bookPageLoader = (BookPageJsonLoader)loader;
                        page = bookPageLoader.fromJson(id, pageJson, provider);
                        pages.add(page);
                        continue;
                    }
                    page = loader.fromJson(pageJson, provider);
                    pages.add(page);
                }
            }
            String name = GsonHelper.getAsString((JsonObject)json, (String)"name");
            String description = GsonHelper.getAsString((JsonObject)json, (String)"description", (String)"");
            BookIcon icon = BookIcon.fromJson(json.get("icon"), provider);
            int entryBackgroundUIndex = GsonHelper.getAsInt((JsonObject)json, (String)"background_u_index", (int)0);
            int entryBackgroundVIndex = GsonHelper.getAsInt((JsonObject)json, (String)"background_v_index", (int)0);
            BookCondition condition = new BookNoneCondition();
            if (json.has("condition")) {
                condition = BookCondition.fromJson(id, json.getAsJsonObject("condition"), provider);
            } else if (autoAddReadConditions) {
                if (parents.size() == 1) {
                    condition = new BookEntryReadCondition(null, ((BookEntryParent)parents.get(0)).getEntryId());
                } else if (parents.size() > 1) {
                    List<BookEntryReadCondition> conditions = parents.stream().map(parent -> new BookEntryReadCondition(null, parent.getEntryId())).toList();
                    condition = new BookAndCondition(null, conditions.toArray(new BookEntryReadCondition[0]));
                }
            }
            boolean hideWhileLocked = GsonHelper.getAsBoolean((JsonObject)json, (String)"hide_while_locked", (boolean)false);
            boolean showWhenAnyParentUnlocked = GsonHelper.getAsBoolean((JsonObject)json, (String)"show_when_any_parent_unlocked", (boolean)false);
            int sortNumber = GsonHelper.getAsInt((JsonObject)json, (String)"sort_number", (int)-1);
            return new BookEntryData(categoryId, parents, x, y, name, description, icon, entryBackgroundUIndex, entryBackgroundVIndex, condition, hideWhileLocked, showWhenAnyParentUnlocked, sortNumber);
        }

        public static BookEntryData fromNetwork(RegistryFriendlyByteBuf buffer) {
            ResourceLocation categoryId = buffer.readResourceLocation();
            String name = buffer.readUtf();
            String description = buffer.readUtf();
            BookIcon icon = BookIcon.fromNetwork(buffer);
            int x = buffer.readVarInt();
            int y = buffer.readVarInt();
            int entryBackgroundUIndex = buffer.readVarInt();
            int entryBackgroundVIndex = buffer.readVarInt();
            boolean hideWhileLocked = buffer.readBoolean();
            boolean showWhenAnyParentUnlocked = buffer.readBoolean();
            BookCondition condition = BookCondition.fromNetwork(buffer);
            ArrayList<BookEntryParent> parentEntries = new ArrayList<BookEntryParent>();
            int parentCount = buffer.readVarInt();
            for (int i = 0; i < parentCount; ++i) {
                parentEntries.add(BookEntryParent.fromNetwork((FriendlyByteBuf)buffer));
            }
            int sortNumber = buffer.readVarInt();
            return new BookEntryData(categoryId, parentEntries, x, y, name, description, icon, entryBackgroundUIndex, entryBackgroundVIndex, condition, hideWhileLocked, showWhenAnyParentUnlocked, sortNumber);
        }

        public void toNetwork(RegistryFriendlyByteBuf buffer) {
            buffer.writeResourceLocation(this.categoryId);
            buffer.writeUtf(this.name);
            buffer.writeUtf(this.description);
            this.icon.toNetwork(buffer);
            buffer.writeVarInt(this.x);
            buffer.writeVarInt(this.y);
            buffer.writeVarInt(this.entryBackgroundUIndex);
            buffer.writeVarInt(this.entryBackgroundVIndex);
            buffer.writeBoolean(this.hideWhileLocked);
            buffer.writeBoolean(this.showWhenAnyParentUnlocked);
            buffer.writeResourceLocation(this.condition.getType());
            this.condition.toNetwork(buffer);
            buffer.writeVarInt(this.parents.size());
            for (BookEntryParent parent : this.parents) {
                parent.toNetwork((FriendlyByteBuf)buffer);
            }
            buffer.writeVarInt(this.sortNumber);
        }
    }
}

