/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.ceramicbucket.platform;

import de.cech12.ceramicbucket.platform.services.IConfigHelper;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class NeoForgeConfigHelper
implements IConfigHelper {
    private static final ModConfigSpec SERVER_CONFIG;
    private static final ModConfigSpec.IntValue BREAK_TEMPERATURE;
    private static final ModConfigSpec.IntValue DURABILITY;
    private static final ModConfigSpec.BooleanValue FISH_OBTAINING_ENABLED;
    private static final ModConfigSpec.BooleanValue MILKING_ENABLED;

    @Override
    public void init() {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    @Override
    public int getBreakTemperature() {
        try {
            return (Integer)BREAK_TEMPERATURE.get();
        }
        catch (IllegalStateException ex) {
            return 1000;
        }
    }

    @Override
    public int getDurability() {
        try {
            return (Integer)DURABILITY.get();
        }
        catch (IllegalStateException ex) {
            return 0;
        }
    }

    @Override
    public boolean isFishObtainingEnabled() {
        try {
            return (Boolean)FISH_OBTAINING_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    @Override
    public boolean isMilkingEnabled() {
        try {
            return (Boolean)MILKING_ENABLED.get();
        }
        catch (IllegalStateException ex) {
            return true;
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Balance Options");
        BREAK_TEMPERATURE = builder.comment("Minimum temperature of fluid at which the Ceramic Bucket breaks when emptied. (default: 1000) (Deactivation by setting a number larger than the hottest fluid)").defineInRange("crackingTemperature", 1000, -10000, 10000);
        DURABILITY = builder.comment("Defines the maximum durability of Ceramic Bucket. (default: 0, 0: deactivates the durability)").defineInRange("durability", 0, 0, 10000);
        FISH_OBTAINING_ENABLED = builder.comment("Whether or not obtaining fish with a Ceramic Bucket should be enabled. (default: true)").define("fishObtainingEnabled", true);
        MILKING_ENABLED = builder.comment("Whether or not milking entities with a Ceramic Bucket should be enabled. (default: true)").define("milkingEnabled", true);
        builder.pop();
        SERVER_CONFIG = builder.build();
    }
}

