/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.ceramicbucket;

import de.cech12.bucketlib.api.BucketLibApi;
import de.cech12.bucketlib.api.item.UniversalBucketItem;
import de.cech12.ceramicbucket.CommonLoader;
import de.cech12.ceramicbucket.init.ModTags;
import de.cech12.ceramicbucket.platform.Services;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="ceramicbucket")
public class CeramicBucketMod {
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"ceramicbucket");
    public static final DeferredItem<Item> UNFIRED_CLAY_BUCKET = ITEMS.register("unfired_clay_bucket", () -> new Item(new Item.Properties()));
    public static final DeferredItem<Item> CERAMIC_BUCKET = ITEMS.register("ceramic_bucket", () -> new UniversalBucketItem(new UniversalBucketItem.Properties().upperCrackingTemperature(Services.CONFIG::getBreakTemperature).crackingFluids(ModTags.Fluids.CERAMIC_CRACKING).milking(Services.CONFIG::isMilkingEnabled).entityObtaining(Services.CONFIG::isFishObtainingEnabled).dyeable(FastColor.ARGB32.color((int)255, (int)14975336)).durability(Services.CONFIG::getDurability)));

    public CeramicBucketMod(IEventBus modEventBus) {
        ITEMS.register(modEventBus);
        modEventBus.addListener(this::addItemsToTabs);
        CommonLoader.init();
        modEventBus.addListener(this::sendImc);
    }

    private void sendImc(RegisterCapabilitiesEvent evt) {
        BucketLibApi.registerBucket((RegisterCapabilitiesEvent)evt, (ResourceLocation)CERAMIC_BUCKET.getId());
    }

    private void addItemsToTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            event.accept(UNFIRED_CLAY_BUCKET);
        }
    }
}

