/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.CornerType;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;
import xfacthd.framedblocks.common.data.property.StairsType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.pillar.PillarDirs;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeedge.SlopeEdgeDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanel.SlopePanelDirs;
import xfacthd.framedblocks.common.data.skippreds.slopepanelcorner.SlopePanelCornerDirs;
import xfacthd.framedblocks.common.data.skippreds.slopeslab.SlopeSlabDirs;
import xfacthd.framedblocks.common.data.skippreds.stairs.StairsDirs;

@CullTest(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
public final class ExtendedCornerSlopePanelWallSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            HorizontalRotation rot = (HorizontalRotation)((Object)state.getValue(PropertyHolder.ROTATION));
            return switch (blockType) {
                case BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstExtendedCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_CORNER_SLOPE_EDGE -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstCornerSlopeEdge(dir, rot, adjState, side);
                case BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstElevatedCornerSlopeEdge(dir, rot, adjState, side);
                case BlockType.FRAMED_SLAB_EDGE -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstSlabEdge(dir, rot, adjState, side);
                case BlockType.FRAMED_SLAB_CORNER -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstSlabCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_HALF_STAIRS -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstHalfStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_STAIRS -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstVerticalStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_VERTICAL_HALF_STAIRS -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstVerticalHalfStairs(dir, rot, adjState, side);
                case BlockType.FRAMED_THREEWAY_CORNER_PILLAR -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstThreewayCornerPillar(dir, rot, adjState, side);
                case BlockType.FRAMED_ELEVATED_SLOPE_SLAB -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstElevatedSlopeSlab(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstFlatElevatedSlopeSlabCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstFlatElevatedInnerSlopeSlabCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_EXTENDED_SLOPE_PANEL -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstExtendedSlopePanel(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstFlatExtendedSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstFlatExtendedInnerSlopePanelCorner(dir, rot, adjState, side);
                case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstSmallCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstSmallInnerCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstExtendedInnerCornerSlopePanelWall(dir, rot, adjState, side);
                case BlockType.FRAMED_MASONRY_CORNER_SEGMENT -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstMasonryCornerSegment(dir, rot, adjState, side);
                case BlockType.FRAMED_CHECKERED_SLAB_SEGMENT -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstCheckeredSlabSegment(dir, rot, adjState, side);
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> ExtendedCornerSlopePanelWallSkipPredicate.testAgainstCheckeredPanelSegment(dir, rot, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(dir, rot, side).isEqualTo(SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(adjDir, adjRot, side.getOpposite())) || SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstCornerSlopeEdge(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        boolean adjAlt = (Boolean)adjState.getValue((Property)PropertyHolder.ALT_TYPE);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlopeEdgeDirs.CornerSlopeEdge.getCornerDir(adjDir, adjType, adjAlt, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_CORNER_SLOPE_EDGE})
    private static boolean testAgainstElevatedCornerSlopeEdge(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        CornerType adjType = (CornerType)((Object)adjState.getValue(PropertyHolder.CORNER_TYPE));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlopeEdgeDirs.ElevatedCornerSlopeEdge.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_EDGE})
    private static boolean testAgainstSlabEdge(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlabDirs.SlabEdge.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SLAB_CORNER})
    private static boolean testAgainstSlabCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlabDirs.SlabCorner.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_HALF_STAIRS})
    private static boolean testAgainstHalfStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjRight = (Boolean)adjState.getValue((Property)PropertyHolder.RIGHT);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(StairsDirs.HalfStairs.getCornerDir(adjDir, adjTop, adjRight, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_STAIRS})
    private static boolean testAgainstVerticalStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        StairsType adjType = (StairsType)((Object)adjState.getValue(PropertyHolder.STAIRS_TYPE));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(StairsDirs.VerticalStairs.getCornerDir(adjDir, adjType, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_VERTICAL_HALF_STAIRS})
    private static boolean testAgainstVerticalHalfStairs(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(StairsDirs.VerticalHalfStairs.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_THREEWAY_CORNER_PILLAR})
    private static boolean testAgainstThreewayCornerPillar(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(PillarDirs.ThreewayCornerPillar.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_ELEVATED_SLOPE_SLAB})
    private static boolean testAgainstElevatedSlopeSlab(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(dir, rot, side).isEqualTo(SlopeSlabDirs.ElevatedSlopeSlab.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedSlopeSlabCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(dir, rot, side).isEqualTo(SlopeSlabDirs.FlatElevatedSlopeSlabCorner.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_ELEV_INNER_SLOPE_SLAB_CORNER})
    private static boolean testAgainstFlatElevatedInnerSlopeSlabCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(dir, rot, side).isEqualTo(SlopeSlabDirs.FlatElevatedInnerSlopeSlabCorner.getTriDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXTENDED_SLOPE_PANEL})
    private static boolean testAgainstExtendedSlopePanel(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(dir, rot, side).isEqualTo(SlopePanelDirs.ExtendedSlopePanel.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(dir, rot, side).isEqualTo(SlopePanelDirs.FlatExtendedSlopePanelCorner.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLAT_EXT_INNER_SLOPE_PANEL_CORNER})
    private static boolean testAgainstFlatExtendedInnerSlopePanelCorner(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(dir, rot, side).isEqualTo(SlopePanelDirs.FlatExtendedInnerSlopePanelCorner.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlopePanelCornerDirs.SmallCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstSmallInnerCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlopePanelCornerDirs.SmallInnerCornerSlopePanelWall.getCornerDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_EXT_INNER_CORNER_SLOPE_PANEL_W})
    private static boolean testAgainstExtendedInnerCornerSlopePanelWall(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        HorizontalRotation adjRot = (HorizontalRotation)((Object)adjState.getValue(PropertyHolder.ROTATION));
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getTriDir(dir, rot, side).isEqualTo(SlopePanelCornerDirs.ExtendedInnerCornerSlopePanelWall.getTriDir(adjDir, adjRot, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_MASONRY_CORNER_SEGMENT})
    private static boolean testAgainstMasonryCornerSegment(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlabDirs.MasonryCornerSegment.getCornerDir(adjDir, adjTop, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_SLAB_SEGMENT})
    private static boolean testAgainstCheckeredSlabSegment(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlabDirs.CheckeredSlabSegment.getCornerDir(adjTop, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(Direction dir, HorizontalRotation rot, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return SlopePanelCornerDirs.ExtendedCornerSlopePanelWall.getCornerDir(dir, rot, side).isEqualTo(SlabDirs.CheckeredPanelSegment.getCornerDir(adjDir, adjSecond, side.getOpposite()));
    }
}

