/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.slab;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.slab.SlabDirs;

@CullTest(value={BlockType.FRAMED_CHECKERED_CUBE_SEGMENT})
public final class CheckeredCubeSegmentSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.getBlock();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            boolean second = (Boolean)state.getValue((Property)PropertyHolder.SECOND);
            return switch (blockType) {
                case BlockType.FRAMED_CHECKERED_CUBE_SEGMENT -> CheckeredCubeSegmentSkipPredicate.testAgainstCheckeredCubeSegment(second, adjState, side);
                case BlockType.FRAMED_CHECKERED_SLAB_SEGMENT -> CheckeredCubeSegmentSkipPredicate.testAgainstCheckeredSlabSegment(second, adjState, side);
                case BlockType.FRAMED_CHECKERED_PANEL_SEGMENT -> CheckeredCubeSegmentSkipPredicate.testAgainstCheckeredPanelSegment(second, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_CUBE_SEGMENT})
    private static boolean testAgainstCheckeredCubeSegment(boolean second, BlockState adjState, Direction side) {
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return SlabDirs.CheckeredCubeSegment.getDiagCornerDir(second, side).isEqualTo(SlabDirs.CheckeredCubeSegment.getDiagCornerDir(adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_SLAB_SEGMENT})
    private static boolean testAgainstCheckeredSlabSegment(boolean second, BlockState adjState, Direction side) {
        boolean adjTop = (Boolean)adjState.getValue((Property)FramedProperties.TOP);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return SlabDirs.CheckeredCubeSegment.getDiagCornerDir(second, side).isEqualTo(SlabDirs.CheckeredSlabSegment.getDiagCornerDir(adjTop, adjSecond, side.getOpposite()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CHECKERED_PANEL_SEGMENT})
    private static boolean testAgainstCheckeredPanelSegment(boolean second, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.getValue((Property)FramedProperties.FACING_HOR);
        boolean adjSecond = (Boolean)adjState.getValue((Property)PropertyHolder.SECOND);
        return SlabDirs.CheckeredCubeSegment.getDiagCornerDir(second, side).isEqualTo(SlabDirs.CheckeredPanelSegment.getDiagCornerDir(adjDir, adjSecond, side.getOpposite()));
    }
}

