/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanelcorner;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.block.PlacementStateBuilder;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.item.VerticalAndWallBlockItem;

public class FramedCornerSlopePanelBlock
extends FramedBlock {
    private final boolean inner;
    private final boolean frontEdge;

    public FramedCornerSlopePanelBlock(BlockType type) {
        super(type);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FramedProperties.TOP, (Comparable)Boolean.valueOf(false))).setValue((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
        this.inner = type == BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL || type == BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL;
        this.frontEdge = type == BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL || type == BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FramedProperties.FACING_HOR, FramedProperties.TOP, FramedProperties.Y_SLOPE, BlockStateProperties.WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        return FramedCornerSlopePanelBlock.getStateForPlacement(this, ctx, this.inner, this.frontEdge);
    }

    public static BlockState getStateForPlacement(Block block, BlockPlaceContext ctx, boolean invert, boolean invertFracDir) {
        return ((PlacementStateBuilder)((PlacementStateBuilder)((PlacementStateBuilder)PlacementStateBuilder.of(block, ctx).withCustom((state, modCtx) -> {
            Direction dir = modCtx.getHorizontalDirection();
            if (invert) {
                dir = dir.getOpposite();
            }
            Direction fracDir = modCtx.getHorizontalDirection();
            if (invertFracDir) {
                fracDir = fracDir.getOpposite();
            }
            if (Utils.fractionInDir(modCtx.getClickLocation(), fracDir.getClockWise()) > 0.5) {
                dir = dir.getClockWise();
            }
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)dir);
        })).withTop()).tryWithWater()).build();
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction side = hit.getDirection();
        Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
        switch (this.getBlockType()) {
            case FRAMED_SMALL_CORNER_SLOPE_PANEL: 
            case FRAMED_LARGE_CORNER_SLOPE_PANEL: {
                if (side != dir.getOpposite() && side != dir.getClockWise()) break;
                side = Direction.UP;
                break;
            }
            case FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL: 
            case FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL: {
                if (side != dir && side != dir.getCounterClockWise()) break;
                boolean top = (Boolean)state.getValue((Property)FramedProperties.TOP);
                Vec3 hitVec = hit.getLocation();
                double y = Utils.fractionInDir(hitVec, top ? Direction.UP : Direction.DOWN);
                double xz = Utils.fractionInDir(hitVec, side == dir ? dir.getCounterClockWise() : dir) - 0.5;
                if (!(xz * 2.0 > y)) break;
                side = Direction.UP;
            }
        }
        return this.rotate(state, side, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        if (Utils.isY(face)) {
            Direction dir = (Direction)state.getValue((Property)FramedProperties.FACING_HOR);
            return (BlockState)state.setValue((Property)FramedProperties.FACING_HOR, (Comparable)rot.rotate(dir));
        }
        return (BlockState)state.cycle((Property)FramedProperties.TOP);
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return this.rotate(state, Direction.UP, rotation);
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return Utils.mirrorCornerBlock(state, mirror);
    }

    @Override
    public BlockItem createBlockItem() {
        Block other = switch (this.getBlockType()) {
            case BlockType.FRAMED_SMALL_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_SMALL_CORNER_SLOPE_PANEL_WALL.value();
            case BlockType.FRAMED_LARGE_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_LARGE_CORNER_SLOPE_PANEL_WALL.value();
            case BlockType.FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_SMALL_INNER_CORNER_SLOPE_PANEL_WALL.value();
            case BlockType.FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL -> (Block)FBContent.BLOCK_FRAMED_LARGE_INNER_CORNER_SLOPE_PANEL_WALL.value();
            default -> throw new IllegalStateException("Unexpected type: " + String.valueOf(this.getBlockType()));
        };
        return new VerticalAndWallBlockItem(this, other, new Item.Properties());
    }

    @Override
    public BlockState getItemModelSource() {
        return (BlockState)this.defaultBlockState().setValue((Property)FramedProperties.FACING_HOR, (Comparable)(this.inner ? Direction.EAST : Direction.WEST));
    }

    @Override
    public BlockState getJadeRenderState(BlockState state) {
        return this.getItemModelSource();
    }
}

