/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.slopepanel;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.client.model.slopepanel.FramedFlatSlopePanelCornerGeometry;
import xfacthd.framedblocks.client.model.slopepanel.FramedSlopePanelGeometry;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatExtendedInnerSlopePanelCornerGeometry
extends Geometry {
    private final Direction facing;
    private final HorizontalRotation rotation;
    private final HorizontalRotation rotRotation;
    private final Direction orientation;
    private final Direction rotOrientation;
    private final boolean ySlope;

    public FramedFlatExtendedInnerSlopePanelCornerGeometry(GeometryFactory.Context ctx) {
        this.facing = (Direction)ctx.state().getValue((Property)FramedProperties.FACING_HOR);
        this.rotation = (HorizontalRotation)((Object)ctx.state().getValue(PropertyHolder.ROTATION));
        this.rotRotation = this.rotation.rotate(Rotation.COUNTERCLOCKWISE_90);
        this.orientation = this.rotation.withFacing(this.facing);
        this.rotOrientation = this.rotRotation.withFacing(this.facing);
        this.ySlope = (Boolean)ctx.state().getValue((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction face = quad.getDirection();
        if (face == this.orientation) {
            FramedFlatSlopePanelCornerGeometry.createSideTriangle(quadMap, quad, this.facing, this.rotRotation, true, true);
            if (this.ySlope && Utils.isY(this.orientation)) {
                QuadModifier.of(quad).apply(FramedFlatSlopePanelCornerGeometry.createVerticalSlopeTriangle(this.facing.getOpposite(), this.orientation, false)).apply(FramedSlopePanelGeometry.createVerticalSlope(this.facing, this.orientation)).apply(Modifiers.offset(this.facing.getOpposite(), 0.5f)).export(quadMap.get(null));
            }
        } else if (face == this.rotOrientation) {
            FramedFlatSlopePanelCornerGeometry.createSideTriangle(quadMap, quad, this.facing, this.rotation, true, true);
            if (this.ySlope && Utils.isY(this.rotOrientation)) {
                QuadModifier.of(quad).apply(FramedFlatSlopePanelCornerGeometry.createVerticalSlopeTriangle(this.facing.getOpposite(), this.rotOrientation, true)).apply(FramedSlopePanelGeometry.createVerticalSlope(this.facing, this.rotOrientation)).apply(Modifiers.offset(this.facing.getOpposite(), 0.5f)).export(quadMap.get(null));
            }
        } else if (face == this.facing.getOpposite()) {
            if (!this.ySlope || !Utils.isY(this.orientation)) {
                QuadModifier.of(quad).apply(FramedFlatSlopePanelCornerGeometry.createSlopeTriangle(this.facing, this.rotOrientation, true)).apply(FramedSlopePanelGeometry.createSlope(this.facing, this.orientation)).export(quadMap.get(null));
            }
            if (!this.ySlope || !Utils.isY(this.rotOrientation)) {
                QuadModifier.of(quad).apply(FramedFlatSlopePanelCornerGeometry.createSlopeTriangle(this.facing, this.orientation, false)).apply(FramedSlopePanelGeometry.createSlope(this.facing, this.rotOrientation)).export(quadMap.get(null));
            }
        } else if (face == this.facing) {
            QuadModifier.of(quad).apply(Modifiers.setPosition(0.5f)).export(quadMap.get(null));
        }
    }
}

