/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.interactive;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.data.QuadMap;
import xfacthd.framedblocks.api.model.geometry.Geometry;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.model.wrapping.GeometryFactory;
import xfacthd.framedblocks.api.util.Utils;

public class FramedWallSignGeometry
extends Geometry {
    private static final float DEPTH = 0.125f;
    private final Direction dir;

    public FramedWallSignGeometry(GeometryFactory.Context ctx) {
        this.dir = (Direction)ctx.state().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
    }

    @Override
    public void transformQuad(QuadMap quadMap, BakedQuad quad) {
        Direction quadDir = quad.getDirection();
        if (quadDir.getAxis() == this.dir.getAxis()) {
            boolean inset = quadDir == this.dir;
            QuadModifier.of(quad).apply(Modifiers.cutSide(0.0f, 0.28125f, 1.0f, 0.78125f)).applyIf(Modifiers.setPosition(0.125f), inset).export(quadMap.get(inset ? null : quadDir));
        } else if (Utils.isY(quadDir)) {
            QuadModifier.of(quad).apply(Modifiers.cutTopBottom(this.dir, 0.125f)).apply(Modifiers.setPosition(quadDir == Direction.UP ? 0.78125f : 0.71875f)).export(quadMap.get(null));
        } else {
            QuadModifier.of(quad).apply(Modifiers.cutSideLeftRight(this.dir, 0.125f)).apply(Modifiers.cutSideUpDown(false, 0.78125f)).apply(Modifiers.cutSideUpDown(true, 0.71875f)).export(quadMap.get(quadDir));
        }
    }
}

